-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Reboot = {}

---@class Reboot.CancelRsp
local TCancelRsp = {}
TCancelRsp.__index = TCancelRsp
TCancelRsp.group = {}

local function TCancelRsp_from_obj(obj)
    return setmetatable(obj, TCancelRsp)
end

function TCancelRsp.new()
    return TCancelRsp_from_obj({})
end
---@param obj Reboot.CancelRsp
function TCancelRsp:init_from_obj(obj)

end

function TCancelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCancelRsp.group)
end

TCancelRsp.from_obj = TCancelRsp_from_obj

TCancelRsp.proto_property = {}

TCancelRsp.default = {}

TCancelRsp.struct = {}

function TCancelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCancelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCancelRsp.proto_property, errs, need_convert)
    return self
end

function TCancelRsp:unpack(_)
end

Reboot.CancelRsp = TCancelRsp

---@class Reboot.CancelReq
local TCancelReq = {}
TCancelReq.__index = TCancelReq
TCancelReq.group = {}

local function TCancelReq_from_obj(obj)
    return setmetatable(obj, TCancelReq)
end

function TCancelReq.new()
    return TCancelReq_from_obj({})
end
---@param obj Reboot.CancelReq
function TCancelReq:init_from_obj(obj)

end

function TCancelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCancelReq.group)
end

TCancelReq.from_obj = TCancelReq_from_obj

TCancelReq.proto_property = {}

TCancelReq.default = {}

TCancelReq.struct = {}

function TCancelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCancelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCancelReq.proto_property, errs, need_convert)
    return self
end

function TCancelReq:unpack(_)
end

Reboot.CancelReq = TCancelReq

---@class Reboot.ActionRsp
---@field Result integer
local TActionRsp = {}
TActionRsp.__index = TActionRsp
TActionRsp.group = {}

local function TActionRsp_from_obj(obj)
    return setmetatable(obj, TActionRsp)
end

function TActionRsp.new(Result)
    return TActionRsp_from_obj({Result = Result})
end
---@param obj Reboot.ActionRsp
function TActionRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TActionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActionRsp.group)
end

TActionRsp.from_obj = TActionRsp_from_obj

TActionRsp.proto_property = {'Result'}

TActionRsp.default = {0}

TActionRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TActionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TActionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActionRsp.proto_property, errs, need_convert)
    return self
end

function TActionRsp:unpack(_)
    return self.Result
end

Reboot.ActionRsp = TActionRsp

---@class Reboot.ActionReq
local TActionReq = {}
TActionReq.__index = TActionReq
TActionReq.group = {}

local function TActionReq_from_obj(obj)
    return setmetatable(obj, TActionReq)
end

function TActionReq.new()
    return TActionReq_from_obj({})
end
---@param obj Reboot.ActionReq
function TActionReq:init_from_obj(obj)

end

function TActionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActionReq.group)
end

TActionReq.from_obj = TActionReq_from_obj

TActionReq.proto_property = {}

TActionReq.default = {}

TActionReq.struct = {}

function TActionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TActionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActionReq.proto_property, errs, need_convert)
    return self
end

function TActionReq:unpack(_)
end

Reboot.ActionReq = TActionReq

---@class Reboot.ProcessRsp
---@field Result integer
local TProcessRsp = {}
TProcessRsp.__index = TProcessRsp
TProcessRsp.group = {}

local function TProcessRsp_from_obj(obj)
    return setmetatable(obj, TProcessRsp)
end

function TProcessRsp.new(Result)
    return TProcessRsp_from_obj({Result = Result})
end
---@param obj Reboot.ProcessRsp
function TProcessRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TProcessRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessRsp.group)
end

TProcessRsp.from_obj = TProcessRsp_from_obj

TProcessRsp.proto_property = {'Result'}

TProcessRsp.default = {0}

TProcessRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TProcessRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TProcessRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessRsp.proto_property, errs, need_convert)
    return self
end

function TProcessRsp:unpack(_)
    return self.Result
end

Reboot.ProcessRsp = TProcessRsp

---@class Reboot.ProcessReq
local TProcessReq = {}
TProcessReq.__index = TProcessReq
TProcessReq.group = {}

local function TProcessReq_from_obj(obj)
    return setmetatable(obj, TProcessReq)
end

function TProcessReq.new()
    return TProcessReq_from_obj({})
end
---@param obj Reboot.ProcessReq
function TProcessReq:init_from_obj(obj)

end

function TProcessReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessReq.group)
end

TProcessReq.from_obj = TProcessReq_from_obj

TProcessReq.proto_property = {}

TProcessReq.default = {}

TProcessReq.struct = {}

function TProcessReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TProcessReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessReq.proto_property, errs, need_convert)
    return self
end

function TProcessReq:unpack(_)
end

Reboot.ProcessReq = TProcessReq

---@class Reboot.PrepareRsp
---@field Result integer
local TPrepareRsp = {}
TPrepareRsp.__index = TPrepareRsp
TPrepareRsp.group = {}

local function TPrepareRsp_from_obj(obj)
    return setmetatable(obj, TPrepareRsp)
end

function TPrepareRsp.new(Result)
    return TPrepareRsp_from_obj({Result = Result})
end
---@param obj Reboot.PrepareRsp
function TPrepareRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TPrepareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrepareRsp.group)
end

TPrepareRsp.from_obj = TPrepareRsp_from_obj

TPrepareRsp.proto_property = {'Result'}

TPrepareRsp.default = {0}

TPrepareRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TPrepareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TPrepareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrepareRsp.proto_property, errs, need_convert)
    return self
end

function TPrepareRsp:unpack(_)
    return self.Result
end

Reboot.PrepareRsp = TPrepareRsp

---@class Reboot.PrepareReq
local TPrepareReq = {}
TPrepareReq.__index = TPrepareReq
TPrepareReq.group = {}

local function TPrepareReq_from_obj(obj)
    return setmetatable(obj, TPrepareReq)
end

function TPrepareReq.new()
    return TPrepareReq_from_obj({})
end
---@param obj Reboot.PrepareReq
function TPrepareReq:init_from_obj(obj)

end

function TPrepareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrepareReq.group)
end

TPrepareReq.from_obj = TPrepareReq_from_obj

TPrepareReq.proto_property = {}

TPrepareReq.default = {}

TPrepareReq.struct = {}

function TPrepareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TPrepareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrepareReq.proto_property, errs, need_convert)
    return self
end

function TPrepareReq:unpack(_)
end

Reboot.PrepareReq = TPrepareReq

Reboot.interface = mdb.register_interface('bmc.kepler.MicroComponent.Reboot', {}, {
    Prepare = {'a{ss}', 'i', TPrepareReq, TPrepareRsp},
    Process = {'a{ss}', 'i', TProcessReq, TProcessRsp},
    Action = {'a{ss}', 'i', TActionReq, TActionRsp},
    Cancel = {'a{ss}', '', TCancelReq, TCancelRsp}
}, {})

return Reboot
