-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerOffLock = {}

---@class PowerOffLock.PowerOffLockedReasons
---@field PowerOffLockedReasons string[]
local TPowerOffLockedReasons = {}
TPowerOffLockedReasons.__index = TPowerOffLockedReasons
TPowerOffLockedReasons.group = {}

local function TPowerOffLockedReasons_from_obj(obj)
    return setmetatable(obj, TPowerOffLockedReasons)
end

function TPowerOffLockedReasons.new(PowerOffLockedReasons)
    return TPowerOffLockedReasons_from_obj({PowerOffLockedReasons = PowerOffLockedReasons})
end
---@param obj PowerOffLock.PowerOffLockedReasons
function TPowerOffLockedReasons:init_from_obj(obj)
    self.PowerOffLockedReasons = obj.PowerOffLockedReasons
end

function TPowerOffLockedReasons:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOffLockedReasons.group)
end

TPowerOffLockedReasons.from_obj = TPowerOffLockedReasons_from_obj

TPowerOffLockedReasons.proto_property = {'PowerOffLockedReasons'}

TPowerOffLockedReasons.default = {{}}

TPowerOffLockedReasons.struct = {{name = 'PowerOffLockedReasons', is_array = true, struct = nil}}

function TPowerOffLockedReasons:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PowerOffLockedReasons', self.PowerOffLockedReasons, 'string', true, errs,
        need_convert)

    TPowerOffLockedReasons:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOffLockedReasons.proto_property, errs, need_convert)
    return self
end

function TPowerOffLockedReasons:unpack(_)
    return self.PowerOffLockedReasons
end

PowerOffLock.PowerOffLockedReasons = TPowerOffLockedReasons

---@class PowerOffLock.PowerOffLocked
---@field PowerOffLocked boolean
local TPowerOffLocked = {}
TPowerOffLocked.__index = TPowerOffLocked
TPowerOffLocked.group = {}

local function TPowerOffLocked_from_obj(obj)
    return setmetatable(obj, TPowerOffLocked)
end

function TPowerOffLocked.new(PowerOffLocked)
    return TPowerOffLocked_from_obj({PowerOffLocked = PowerOffLocked})
end
---@param obj PowerOffLock.PowerOffLocked
function TPowerOffLocked:init_from_obj(obj)
    self.PowerOffLocked = obj.PowerOffLocked
end

function TPowerOffLocked:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOffLocked.group)
end

TPowerOffLocked.from_obj = TPowerOffLocked_from_obj

TPowerOffLocked.proto_property = {'PowerOffLocked'}

TPowerOffLocked.default = {false}

TPowerOffLocked.struct = {{name = 'PowerOffLocked', is_array = false, struct = nil}}

function TPowerOffLocked:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOffLocked', self.PowerOffLocked, 'bool', true, errs, need_convert)

    TPowerOffLocked:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOffLocked.proto_property, errs, need_convert)
    return self
end

function TPowerOffLocked:unpack(_)
    return self.PowerOffLocked
end

PowerOffLock.PowerOffLocked = TPowerOffLocked

---@class PowerOffLock.SetPowerOffLockRsp
local TSetPowerOffLockRsp = {}
TSetPowerOffLockRsp.__index = TSetPowerOffLockRsp
TSetPowerOffLockRsp.group = {}

local function TSetPowerOffLockRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerOffLockRsp)
end

function TSetPowerOffLockRsp.new()
    return TSetPowerOffLockRsp_from_obj({})
end
---@param obj PowerOffLock.SetPowerOffLockRsp
function TSetPowerOffLockRsp:init_from_obj(obj)

end

function TSetPowerOffLockRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOffLockRsp.group)
end

TSetPowerOffLockRsp.from_obj = TSetPowerOffLockRsp_from_obj

TSetPowerOffLockRsp.proto_property = {}

TSetPowerOffLockRsp.default = {}

TSetPowerOffLockRsp.struct = {}

function TSetPowerOffLockRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPowerOffLockRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOffLockRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerOffLockRsp:unpack(_)
end

PowerOffLock.SetPowerOffLockRsp = TSetPowerOffLockRsp

---@class PowerOffLock.SetPowerOffLockReq
---@field Locked boolean
---@field Timeout integer
---@field AppName string
---@field Reason string
local TSetPowerOffLockReq = {}
TSetPowerOffLockReq.__index = TSetPowerOffLockReq
TSetPowerOffLockReq.group = {}

local function TSetPowerOffLockReq_from_obj(obj)
    return setmetatable(obj, TSetPowerOffLockReq)
end

function TSetPowerOffLockReq.new(Locked, Timeout, AppName, Reason)
    return TSetPowerOffLockReq_from_obj({Locked = Locked, Timeout = Timeout, AppName = AppName, Reason = Reason})
end
---@param obj PowerOffLock.SetPowerOffLockReq
function TSetPowerOffLockReq:init_from_obj(obj)
    self.Locked = obj.Locked
    self.Timeout = obj.Timeout
    self.AppName = obj.AppName
    self.Reason = obj.Reason
end

function TSetPowerOffLockReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOffLockReq.group)
end

TSetPowerOffLockReq.from_obj = TSetPowerOffLockReq_from_obj

TSetPowerOffLockReq.proto_property = {'Locked', 'Timeout', 'AppName', 'Reason'}

TSetPowerOffLockReq.default = {false, 0, '', ''}

TSetPowerOffLockReq.struct = {
    {name = 'Locked', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil},
    {name = 'AppName', is_array = false, struct = nil}, {name = 'Reason', is_array = false, struct = nil}
}

function TSetPowerOffLockReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Locked', self.Locked, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'AppName', self.AppName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Reason', self.Reason, 'string', false, errs, need_convert)

    TSetPowerOffLockReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOffLockReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerOffLockReq:unpack(_)
    return self.Locked, self.Timeout, self.AppName, self.Reason
end

PowerOffLock.SetPowerOffLockReq = TSetPowerOffLockReq

PowerOffLock.interface = mdb.register_interface('bmc.kepler.FruCtrl.PowerOffLock', {
    PowerOffLocked = {'b', {}, true, nil},
    PowerOffLockedReasons = {'as', {}, true, nil}
}, {SetPowerOffLock = {'a{ss}buss', '', TSetPowerOffLockReq, TSetPowerOffLockRsp}}, {})

return PowerOffLock
