-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Multihost = {}

---@class Multihost.HostCount
---@field HostCount integer
local THostCount = {}
THostCount.__index = THostCount
THostCount.group = {}

local function THostCount_from_obj(obj)
    return setmetatable(obj, THostCount)
end

function THostCount.new(HostCount)
    return THostCount_from_obj({HostCount = HostCount or 1})
end
---@param obj Multihost.HostCount
function THostCount:init_from_obj(obj)
    self.HostCount = obj.HostCount or 1
end

function THostCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THostCount.group)
end

THostCount.from_obj = THostCount_from_obj

THostCount.proto_property = {'HostCount'}

THostCount.default = {0}

THostCount.struct = {{name = 'HostCount', is_array = false, struct = nil}}

function THostCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HostCount', self.HostCount, 'uint8', true, errs, need_convert)

    if self.HostCount ~= nil then
        validate.ranges(prefix .. 'HostCount', self.HostCount, 1, 63, errs, need_convert)
    end

    THostCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THostCount.proto_property, errs, need_convert)
    return self
end

function THostCount:unpack(_)
    return self.HostCount
end

Multihost.HostCount = THostCount

---@class Multihost.HostType
---@field HostType string
local THostType = {}
THostType.__index = THostType
THostType.group = {}

local function THostType_from_obj(obj)
    return setmetatable(obj, THostType)
end

function THostType.new(HostType)
    return THostType_from_obj({HostType = HostType or [=[Singlehost]=]})
end
---@param obj Multihost.HostType
function THostType:init_from_obj(obj)
    self.HostType = obj.HostType or [=[Singlehost]=]
end

function THostType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THostType.group)
end

THostType.from_obj = THostType_from_obj

THostType.proto_property = {'HostType'}

THostType.default = {''}

THostType.struct = {{name = 'HostType', is_array = false, struct = nil}}

function THostType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HostType', self.HostType, 'string', true, errs, need_convert)

    if self.HostType ~= nil then
        validate.Enum(prefix .. 'HostType', self.HostType, '', {'Singlehost', 'Multihost'}, errs, need_convert)
    end

    THostType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THostType.proto_property, errs, need_convert)
    return self
end

function THostType:unpack(_)
    return self.HostType
end

Multihost.HostType = THostType

Multihost.interface = mdb.register_interface('bmc.kepler.Managers.Multihost', {
    HostType = {'s', {}, true, 'Singlehost'},
    HostCount = {'y', {}, true, 1}
}, {}, {})

return Multihost
