-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FruCtrlCapabilities = {}

---@class FruCtrlCapabilities.GlobalPowerCycleSupported
---@field GlobalPowerCycleSupported boolean
local TGlobalPowerCycleSupported = {}
TGlobalPowerCycleSupported.__index = TGlobalPowerCycleSupported
TGlobalPowerCycleSupported.group = {}

local function TGlobalPowerCycleSupported_from_obj(obj)
    return setmetatable(obj, TGlobalPowerCycleSupported)
end

function TGlobalPowerCycleSupported.new(GlobalPowerCycleSupported)
    return TGlobalPowerCycleSupported_from_obj({GlobalPowerCycleSupported = GlobalPowerCycleSupported})
end
---@param obj FruCtrlCapabilities.GlobalPowerCycleSupported
function TGlobalPowerCycleSupported:init_from_obj(obj)
    self.GlobalPowerCycleSupported = obj.GlobalPowerCycleSupported
end

function TGlobalPowerCycleSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGlobalPowerCycleSupported.group)
end

TGlobalPowerCycleSupported.from_obj = TGlobalPowerCycleSupported_from_obj

TGlobalPowerCycleSupported.proto_property = {'GlobalPowerCycleSupported'}

TGlobalPowerCycleSupported.default = {false}

TGlobalPowerCycleSupported.struct = {{name = 'GlobalPowerCycleSupported', is_array = false, struct = nil}}

function TGlobalPowerCycleSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GlobalPowerCycleSupported', self.GlobalPowerCycleSupported, 'bool', true, errs,
        need_convert)

    TGlobalPowerCycleSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGlobalPowerCycleSupported.proto_property, errs, need_convert)
    return self
end

function TGlobalPowerCycleSupported:unpack(_)
    return self.GlobalPowerCycleSupported
end

FruCtrlCapabilities.GlobalPowerCycleSupported = TGlobalPowerCycleSupported

---@class FruCtrlCapabilities.GlobalRestartSupported
---@field GlobalRestartSupported boolean
local TGlobalRestartSupported = {}
TGlobalRestartSupported.__index = TGlobalRestartSupported
TGlobalRestartSupported.group = {}

local function TGlobalRestartSupported_from_obj(obj)
    return setmetatable(obj, TGlobalRestartSupported)
end

function TGlobalRestartSupported.new(GlobalRestartSupported)
    return TGlobalRestartSupported_from_obj({GlobalRestartSupported = GlobalRestartSupported})
end
---@param obj FruCtrlCapabilities.GlobalRestartSupported
function TGlobalRestartSupported:init_from_obj(obj)
    self.GlobalRestartSupported = obj.GlobalRestartSupported
end

function TGlobalRestartSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGlobalRestartSupported.group)
end

TGlobalRestartSupported.from_obj = TGlobalRestartSupported_from_obj

TGlobalRestartSupported.proto_property = {'GlobalRestartSupported'}

TGlobalRestartSupported.default = {false}

TGlobalRestartSupported.struct = {{name = 'GlobalRestartSupported', is_array = false, struct = nil}}

function TGlobalRestartSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GlobalRestartSupported', self.GlobalRestartSupported, 'bool', true, errs, need_convert)

    TGlobalRestartSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGlobalRestartSupported.proto_property, errs, need_convert)
    return self
end

function TGlobalRestartSupported:unpack(_)
    return self.GlobalRestartSupported
end

FruCtrlCapabilities.GlobalRestartSupported = TGlobalRestartSupported

---@class FruCtrlCapabilities.GlobalPowerOffSupported
---@field GlobalPowerOffSupported boolean
local TGlobalPowerOffSupported = {}
TGlobalPowerOffSupported.__index = TGlobalPowerOffSupported
TGlobalPowerOffSupported.group = {}

local function TGlobalPowerOffSupported_from_obj(obj)
    return setmetatable(obj, TGlobalPowerOffSupported)
end

function TGlobalPowerOffSupported.new(GlobalPowerOffSupported)
    return TGlobalPowerOffSupported_from_obj({GlobalPowerOffSupported = GlobalPowerOffSupported})
end
---@param obj FruCtrlCapabilities.GlobalPowerOffSupported
function TGlobalPowerOffSupported:init_from_obj(obj)
    self.GlobalPowerOffSupported = obj.GlobalPowerOffSupported
end

function TGlobalPowerOffSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGlobalPowerOffSupported.group)
end

TGlobalPowerOffSupported.from_obj = TGlobalPowerOffSupported_from_obj

TGlobalPowerOffSupported.proto_property = {'GlobalPowerOffSupported'}

TGlobalPowerOffSupported.default = {false}

TGlobalPowerOffSupported.struct = {{name = 'GlobalPowerOffSupported', is_array = false, struct = nil}}

function TGlobalPowerOffSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GlobalPowerOffSupported', self.GlobalPowerOffSupported, 'bool', true, errs,
        need_convert)

    TGlobalPowerOffSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGlobalPowerOffSupported.proto_property, errs, need_convert)
    return self
end

function TGlobalPowerOffSupported:unpack(_)
    return self.GlobalPowerOffSupported
end

FruCtrlCapabilities.GlobalPowerOffSupported = TGlobalPowerOffSupported

---@class FruCtrlCapabilities.ForcePowerCycleSupported
---@field ForcePowerCycleSupported boolean
local TForcePowerCycleSupported = {}
TForcePowerCycleSupported.__index = TForcePowerCycleSupported
TForcePowerCycleSupported.group = {}

local function TForcePowerCycleSupported_from_obj(obj)
    return setmetatable(obj, TForcePowerCycleSupported)
end

function TForcePowerCycleSupported.new(ForcePowerCycleSupported)
    return TForcePowerCycleSupported_from_obj({ForcePowerCycleSupported = ForcePowerCycleSupported})
end
---@param obj FruCtrlCapabilities.ForcePowerCycleSupported
function TForcePowerCycleSupported:init_from_obj(obj)
    self.ForcePowerCycleSupported = obj.ForcePowerCycleSupported
end

function TForcePowerCycleSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForcePowerCycleSupported.group)
end

TForcePowerCycleSupported.from_obj = TForcePowerCycleSupported_from_obj

TForcePowerCycleSupported.proto_property = {'ForcePowerCycleSupported'}

TForcePowerCycleSupported.default = {false}

TForcePowerCycleSupported.struct = {{name = 'ForcePowerCycleSupported', is_array = false, struct = nil}}

function TForcePowerCycleSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ForcePowerCycleSupported', self.ForcePowerCycleSupported, 'bool', true, errs,
        need_convert)

    TForcePowerCycleSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForcePowerCycleSupported.proto_property, errs, need_convert)
    return self
end

function TForcePowerCycleSupported:unpack(_)
    return self.ForcePowerCycleSupported
end

FruCtrlCapabilities.ForcePowerCycleSupported = TForcePowerCycleSupported

---@class FruCtrlCapabilities.PowerCycleSupported
---@field PowerCycleSupported boolean
local TPowerCycleSupported = {}
TPowerCycleSupported.__index = TPowerCycleSupported
TPowerCycleSupported.group = {}

local function TPowerCycleSupported_from_obj(obj)
    return setmetatable(obj, TPowerCycleSupported)
end

function TPowerCycleSupported.new(PowerCycleSupported)
    return TPowerCycleSupported_from_obj({PowerCycleSupported = PowerCycleSupported})
end
---@param obj FruCtrlCapabilities.PowerCycleSupported
function TPowerCycleSupported:init_from_obj(obj)
    self.PowerCycleSupported = obj.PowerCycleSupported
end

function TPowerCycleSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCycleSupported.group)
end

TPowerCycleSupported.from_obj = TPowerCycleSupported_from_obj

TPowerCycleSupported.proto_property = {'PowerCycleSupported'}

TPowerCycleSupported.default = {false}

TPowerCycleSupported.struct = {{name = 'PowerCycleSupported', is_array = false, struct = nil}}

function TPowerCycleSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCycleSupported', self.PowerCycleSupported, 'bool', true, errs, need_convert)

    TPowerCycleSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCycleSupported.proto_property, errs, need_convert)
    return self
end

function TPowerCycleSupported:unpack(_)
    return self.PowerCycleSupported
end

FruCtrlCapabilities.PowerCycleSupported = TPowerCycleSupported

---@class FruCtrlCapabilities.ForceOffSupported
---@field ForceOffSupported boolean
local TForceOffSupported = {}
TForceOffSupported.__index = TForceOffSupported
TForceOffSupported.group = {}

local function TForceOffSupported_from_obj(obj)
    return setmetatable(obj, TForceOffSupported)
end

function TForceOffSupported.new(ForceOffSupported)
    return TForceOffSupported_from_obj({ForceOffSupported = ForceOffSupported})
end
---@param obj FruCtrlCapabilities.ForceOffSupported
function TForceOffSupported:init_from_obj(obj)
    self.ForceOffSupported = obj.ForceOffSupported
end

function TForceOffSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForceOffSupported.group)
end

TForceOffSupported.from_obj = TForceOffSupported_from_obj

TForceOffSupported.proto_property = {'ForceOffSupported'}

TForceOffSupported.default = {false}

TForceOffSupported.struct = {{name = 'ForceOffSupported', is_array = false, struct = nil}}

function TForceOffSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ForceOffSupported', self.ForceOffSupported, 'bool', true, errs, need_convert)

    TForceOffSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForceOffSupported.proto_property, errs, need_convert)
    return self
end

function TForceOffSupported:unpack(_)
    return self.ForceOffSupported
end

FruCtrlCapabilities.ForceOffSupported = TForceOffSupported

---@class FruCtrlCapabilities.ForceRestartSupported
---@field ForceRestartSupported boolean
local TForceRestartSupported = {}
TForceRestartSupported.__index = TForceRestartSupported
TForceRestartSupported.group = {}

local function TForceRestartSupported_from_obj(obj)
    return setmetatable(obj, TForceRestartSupported)
end

function TForceRestartSupported.new(ForceRestartSupported)
    return TForceRestartSupported_from_obj({ForceRestartSupported = ForceRestartSupported})
end
---@param obj FruCtrlCapabilities.ForceRestartSupported
function TForceRestartSupported:init_from_obj(obj)
    self.ForceRestartSupported = obj.ForceRestartSupported
end

function TForceRestartSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForceRestartSupported.group)
end

TForceRestartSupported.from_obj = TForceRestartSupported_from_obj

TForceRestartSupported.proto_property = {'ForceRestartSupported'}

TForceRestartSupported.default = {false}

TForceRestartSupported.struct = {{name = 'ForceRestartSupported', is_array = false, struct = nil}}

function TForceRestartSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ForceRestartSupported', self.ForceRestartSupported, 'bool', true, errs, need_convert)

    TForceRestartSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForceRestartSupported.proto_property, errs, need_convert)
    return self
end

function TForceRestartSupported:unpack(_)
    return self.ForceRestartSupported
end

FruCtrlCapabilities.ForceRestartSupported = TForceRestartSupported

---@class FruCtrlCapabilities.MultihostSupported
---@field MultihostSupported boolean
local TMultihostSupported = {}
TMultihostSupported.__index = TMultihostSupported
TMultihostSupported.group = {}

local function TMultihostSupported_from_obj(obj)
    return setmetatable(obj, TMultihostSupported)
end

function TMultihostSupported.new(MultihostSupported)
    return TMultihostSupported_from_obj({MultihostSupported = MultihostSupported})
end
---@param obj FruCtrlCapabilities.MultihostSupported
function TMultihostSupported:init_from_obj(obj)
    self.MultihostSupported = obj.MultihostSupported
end

function TMultihostSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultihostSupported.group)
end

TMultihostSupported.from_obj = TMultihostSupported_from_obj

TMultihostSupported.proto_property = {'MultihostSupported'}

TMultihostSupported.default = {false}

TMultihostSupported.struct = {{name = 'MultihostSupported', is_array = false, struct = nil}}

function TMultihostSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MultihostSupported', self.MultihostSupported, 'bool', true, errs, need_convert)

    TMultihostSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultihostSupported.proto_property, errs, need_convert)
    return self
end

function TMultihostSupported:unpack(_)
    return self.MultihostSupported
end

FruCtrlCapabilities.MultihostSupported = TMultihostSupported

---@class FruCtrlCapabilities.GlobalDomainSupported
---@field GlobalDomainSupported boolean
local TGlobalDomainSupported = {}
TGlobalDomainSupported.__index = TGlobalDomainSupported
TGlobalDomainSupported.group = {}

local function TGlobalDomainSupported_from_obj(obj)
    return setmetatable(obj, TGlobalDomainSupported)
end

function TGlobalDomainSupported.new(GlobalDomainSupported)
    return TGlobalDomainSupported_from_obj({GlobalDomainSupported = GlobalDomainSupported})
end
---@param obj FruCtrlCapabilities.GlobalDomainSupported
function TGlobalDomainSupported:init_from_obj(obj)
    self.GlobalDomainSupported = obj.GlobalDomainSupported
end

function TGlobalDomainSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGlobalDomainSupported.group)
end

TGlobalDomainSupported.from_obj = TGlobalDomainSupported_from_obj

TGlobalDomainSupported.proto_property = {'GlobalDomainSupported'}

TGlobalDomainSupported.default = {false}

TGlobalDomainSupported.struct = {{name = 'GlobalDomainSupported', is_array = false, struct = nil}}

function TGlobalDomainSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GlobalDomainSupported', self.GlobalDomainSupported, 'bool', true, errs, need_convert)

    TGlobalDomainSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGlobalDomainSupported.proto_property, errs, need_convert)
    return self
end

function TGlobalDomainSupported:unpack(_)
    return self.GlobalDomainSupported
end

FruCtrlCapabilities.GlobalDomainSupported = TGlobalDomainSupported

FruCtrlCapabilities.interface = mdb.register_interface('bmc.kepler.ProductInfo.FruCtrlCapabilities', {
    GlobalDomainSupported = {'b', nil, true, nil},
    MultihostSupported = {'b', nil, true, nil},
    ForceRestartSupported = {'b', {}, true, nil},
    ForceOffSupported = {'b', {}, true, nil},
    PowerCycleSupported = {'b', {}, true, nil},
    ForcePowerCycleSupported = {'b', {}, true, nil},
    GlobalPowerOffSupported = {'b', {}, true, nil},
    GlobalRestartSupported = {'b', {}, true, nil},
    GlobalPowerCycleSupported = {'b', {}, true, nil}
}, {}, {})

return FruCtrlCapabilities
