-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local Env = {}

---@class Env.EnvActiveModes: Enum
local EEnvActiveModes = create_enum_type('EnvActiveModes')
EEnvActiveModes.default = EEnvActiveModes.new(2147483647)
EEnvActiveModes.struct = nil
EEnvActiveModes.None = EEnvActiveModes.new(0)
EEnvActiveModes.ResetBMC = EEnvActiveModes.new(1)
EEnvActiveModes.ResetBMCAndSecureCore = EEnvActiveModes.new(2)
EEnvActiveModes.ResetBMCAndSecureCoreOnPowerDown = EEnvActiveModes.new(3)
EEnvActiveModes.ACCycle = EEnvActiveModes.new(4)

Env.EnvActiveModes = EEnvActiveModes

Env.interface = mdb.register_interface('bmc.kepler.Managers.SOC.Env', {
    LoadCompleted = {'b', nil, false, false},
    IsChanged = {'b', nil, false, false},
    ActiveMode = {'i', nil, false, utils.unpack_enum(true, EEnvActiveModes.None)},
    SystemIds = {'au', nil, false, {1}}
}, {}, {})

return Env
