--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetRestorePolicy = {}

---@class fructrl.SetRestorePolicyReq
---@field RestorePolicy integer
local TSetRestorePolicyReq = {}
TSetRestorePolicyReq.__index = TSetRestorePolicyReq
TSetRestorePolicyReq.group = {}

local function TSetRestorePolicyReq_from_obj(obj)
    return setmetatable(obj, TSetRestorePolicyReq)
end

function TSetRestorePolicyReq.new(RestorePolicy)
    return TSetRestorePolicyReq_from_obj({RestorePolicy = RestorePolicy})
end
---@param obj fructrl.SetRestorePolicyReq
function TSetRestorePolicyReq:init_from_obj(obj)
    self.RestorePolicy = obj.RestorePolicy
end

function TSetRestorePolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRestorePolicyReq.group)
end

TSetRestorePolicyReq.from_obj = TSetRestorePolicyReq_from_obj

TSetRestorePolicyReq.proto_property = {'RestorePolicy'}

TSetRestorePolicyReq.default = {0}

TSetRestorePolicyReq.struct = {{name = 'RestorePolicy', is_array = false, struct = nil}}

function TSetRestorePolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RestorePolicy', self.RestorePolicy, 'uint8', false, errs, need_convert)

    TSetRestorePolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRestorePolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetRestorePolicyReq:unpack(_)
    return self.RestorePolicy
end

SetRestorePolicy.SetRestorePolicyReq = TSetRestorePolicyReq

---@class fructrl.SetRestorePolicyRsp
---@field CompletionCode integer
---@field RestorePolicy integer
local TSetRestorePolicyRsp = {}
TSetRestorePolicyRsp.__index = TSetRestorePolicyRsp
TSetRestorePolicyRsp.group = {}

local function TSetRestorePolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetRestorePolicyRsp)
end

function TSetRestorePolicyRsp.new(CompletionCode, RestorePolicy)
    return TSetRestorePolicyRsp_from_obj({CompletionCode = CompletionCode, RestorePolicy = RestorePolicy})
end
---@param obj fructrl.SetRestorePolicyRsp
function TSetRestorePolicyRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RestorePolicy = obj.RestorePolicy
end

function TSetRestorePolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRestorePolicyRsp.group)
end

TSetRestorePolicyRsp.from_obj = TSetRestorePolicyRsp_from_obj

TSetRestorePolicyRsp.proto_property = {'CompletionCode', 'RestorePolicy'}

TSetRestorePolicyRsp.default = {0, 0}

TSetRestorePolicyRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RestorePolicy', is_array = false, struct = nil}
}

function TSetRestorePolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RestorePolicy', self.RestorePolicy, 'uint8', false, errs, need_convert)

    TSetRestorePolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRestorePolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetRestorePolicyRsp:unpack(_)
    return self.CompletionCode, self.RestorePolicy
end

SetRestorePolicy.SetRestorePolicyRsp = TSetRestorePolicyRsp

return SetRestorePolicy
