--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFruActivation = {}

---@class fructrl.SetFruActivationReq
---@field FruId integer
---@field Cmd integer
local TSetFruActivationReq = {}
TSetFruActivationReq.__index = TSetFruActivationReq
TSetFruActivationReq.group = {}

local function TSetFruActivationReq_from_obj(obj)
    return setmetatable(obj, TSetFruActivationReq)
end

function TSetFruActivationReq.new(FruId, Cmd)
    return TSetFruActivationReq_from_obj({FruId = FruId, Cmd = Cmd})
end
---@param obj fructrl.SetFruActivationReq
function TSetFruActivationReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Cmd = obj.Cmd
end

function TSetFruActivationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFruActivationReq.group)
end

TSetFruActivationReq.from_obj = TSetFruActivationReq_from_obj

TSetFruActivationReq.proto_property = {'FruId', 'Cmd'}

TSetFruActivationReq.default = {0, 0}

TSetFruActivationReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Cmd', is_array = false, struct = nil}
}

function TSetFruActivationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Cmd', self.Cmd, 'uint8', false, errs, need_convert)

    TSetFruActivationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFruActivationReq.proto_property, errs, need_convert)
    return self
end

function TSetFruActivationReq:unpack(_)
    return self.FruId, self.Cmd
end

SetFruActivation.SetFruActivationReq = TSetFruActivationReq

---@class fructrl.SetFruActivationRsp
---@field CompletionCode integer
local TSetFruActivationRsp = {}
TSetFruActivationRsp.__index = TSetFruActivationRsp
TSetFruActivationRsp.group = {}

local function TSetFruActivationRsp_from_obj(obj)
    return setmetatable(obj, TSetFruActivationRsp)
end

function TSetFruActivationRsp.new(CompletionCode)
    return TSetFruActivationRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj fructrl.SetFruActivationRsp
function TSetFruActivationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetFruActivationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFruActivationRsp.group)
end

TSetFruActivationRsp.from_obj = TSetFruActivationRsp_from_obj

TSetFruActivationRsp.proto_property = {'CompletionCode'}

TSetFruActivationRsp.default = {0}

TSetFruActivationRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetFruActivationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetFruActivationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFruActivationRsp.proto_property, errs, need_convert)
    return self
end

function TSetFruActivationRsp:unpack(_)
    return self.CompletionCode
end

SetFruActivation.SetFruActivationRsp = TSetFruActivationRsp

return SetFruActivation
