--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetButtonShieldState = {}

---@class fructrl.GetButtonShieldStateReq
---@field ManufactureId integer
---@field FruId integer
local TGetButtonShieldStateReq = {}
TGetButtonShieldStateReq.__index = TGetButtonShieldStateReq
TGetButtonShieldStateReq.group = {}

local function TGetButtonShieldStateReq_from_obj(obj)
    return setmetatable(obj, TGetButtonShieldStateReq)
end

function TGetButtonShieldStateReq.new(ManufactureId, FruId)
    return TGetButtonShieldStateReq_from_obj({ManufactureId = ManufactureId, FruId = FruId})
end
---@param obj fructrl.GetButtonShieldStateReq
function TGetButtonShieldStateReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.FruId = obj.FruId
end

function TGetButtonShieldStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetButtonShieldStateReq.group)
end

TGetButtonShieldStateReq.from_obj = TGetButtonShieldStateReq_from_obj

TGetButtonShieldStateReq.proto_property = {'ManufactureId', 'FruId'}

TGetButtonShieldStateReq.default = {0, 0}

TGetButtonShieldStateReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil}
}

function TGetButtonShieldStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)

    TGetButtonShieldStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetButtonShieldStateReq.proto_property, errs, need_convert)
    return self
end

function TGetButtonShieldStateReq:unpack(_)
    return self.ManufactureId, self.FruId
end

GetButtonShieldState.GetButtonShieldStateReq = TGetButtonShieldStateReq

---@class fructrl.GetButtonShieldStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field State integer
local TGetButtonShieldStateRsp = {}
TGetButtonShieldStateRsp.__index = TGetButtonShieldStateRsp
TGetButtonShieldStateRsp.group = {}

local function TGetButtonShieldStateRsp_from_obj(obj)
    return setmetatable(obj, TGetButtonShieldStateRsp)
end

function TGetButtonShieldStateRsp.new(CompletionCode, ManufactureId, State)
    return TGetButtonShieldStateRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        State = State
    })
end
---@param obj fructrl.GetButtonShieldStateRsp
function TGetButtonShieldStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.State = obj.State
end

function TGetButtonShieldStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetButtonShieldStateRsp.group)
end

TGetButtonShieldStateRsp.from_obj = TGetButtonShieldStateRsp_from_obj

TGetButtonShieldStateRsp.proto_property = {'CompletionCode', 'ManufactureId', 'State'}

TGetButtonShieldStateRsp.default = {0, 0, 0}

TGetButtonShieldStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TGetButtonShieldStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TGetButtonShieldStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetButtonShieldStateRsp.proto_property, errs, need_convert)
    return self
end

function TGetButtonShieldStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.State
end

GetButtonShieldState.GetButtonShieldStateRsp = TGetButtonShieldStateRsp

return GetButtonShieldState
