--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local CMDGetRestartCause = {}

---@class fructrl.CMDGetRestartCauseReq
local TCMDGetRestartCauseReq = {}
TCMDGetRestartCauseReq.__index = TCMDGetRestartCauseReq
TCMDGetRestartCauseReq.group = {}

local function TCMDGetRestartCauseReq_from_obj(obj)
    return setmetatable(obj, TCMDGetRestartCauseReq)
end

function TCMDGetRestartCauseReq.new()
    return TCMDGetRestartCauseReq_from_obj({})
end
---@param obj fructrl.CMDGetRestartCauseReq
function TCMDGetRestartCauseReq:init_from_obj(obj)

end

function TCMDGetRestartCauseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCMDGetRestartCauseReq.group)
end

TCMDGetRestartCauseReq.from_obj = TCMDGetRestartCauseReq_from_obj

TCMDGetRestartCauseReq.proto_property = {}

TCMDGetRestartCauseReq.default = {}

TCMDGetRestartCauseReq.struct = {}

function TCMDGetRestartCauseReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCMDGetRestartCauseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCMDGetRestartCauseReq.proto_property, errs, need_convert)
    return self
end

function TCMDGetRestartCauseReq:unpack(_)
end

CMDGetRestartCause.CMDGetRestartCauseReq = TCMDGetRestartCauseReq

---@class fructrl.CMDGetRestartCauseRsp
---@field CompletionCode integer
---@field RestartCause integer
---@field SrcChan integer
local TCMDGetRestartCauseRsp = {}
TCMDGetRestartCauseRsp.__index = TCMDGetRestartCauseRsp
TCMDGetRestartCauseRsp.group = {}

local function TCMDGetRestartCauseRsp_from_obj(obj)
    return setmetatable(obj, TCMDGetRestartCauseRsp)
end

function TCMDGetRestartCauseRsp.new(CompletionCode, RestartCause, SrcChan)
    return TCMDGetRestartCauseRsp_from_obj({
        CompletionCode = CompletionCode,
        RestartCause = RestartCause,
        SrcChan = SrcChan
    })
end
---@param obj fructrl.CMDGetRestartCauseRsp
function TCMDGetRestartCauseRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RestartCause = obj.RestartCause
    self.SrcChan = obj.SrcChan
end

function TCMDGetRestartCauseRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCMDGetRestartCauseRsp.group)
end

TCMDGetRestartCauseRsp.from_obj = TCMDGetRestartCauseRsp_from_obj

TCMDGetRestartCauseRsp.proto_property = {'CompletionCode', 'RestartCause', 'SrcChan'}

TCMDGetRestartCauseRsp.default = {0, 0, 0}

TCMDGetRestartCauseRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RestartCause', is_array = false, struct = nil},
    {name = 'SrcChan', is_array = false, struct = nil}
}

function TCMDGetRestartCauseRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RestartCause', self.RestartCause, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SrcChan', self.SrcChan, 'uint8', false, errs, need_convert)

    TCMDGetRestartCauseRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCMDGetRestartCauseRsp.proto_property, errs, need_convert)
    return self
end

function TCMDGetRestartCauseRsp:unpack(_)
    return self.CompletionCode, self.RestartCause, self.SrcChan
end

CMDGetRestartCause.CMDGetRestartCauseRsp = TCMDGetRestartCauseRsp

return CMDGetRestartCause
