# fructrl上下电管理

## 功能简介
- 上下电主要是接收北向控制命令，包括修改属性和调用rpc方法，最终通过硬件代理模块写cpld寄存器进行模拟短按或者长按实现对OS的上电、下电、复位等相关功能
- 上下电支持对bmc控制板和os侧同时下电，这种操作称为整框掉电

## 关键特性

### 2.1 状态机

- 上下电功能使用状态机确保命令有序执行

- 控制状态机直接跟业务功能相关，用于实现上电、下电的状态变迁

- 热插拔状态机与规范要求相关，控制状态机驱动热插拔状态机运行

### 2.2 软件上电锁

- BMC提供的升级固件服务中，要求升级或生效过程中不能做上电操作
    
- 升级专用上电锁提供给BMC升级模块，升级或生效前，向fructrl提出上锁请求，在请求锁定的时间内，fructrl不响应任何上电命令，避免打断升级生效任务

### 2.3 硬件上电锁

- 指的是默认状态下，如果出现服务器在指定时间内未完成上电，则通过BMC锁定服务器上电功能，服务器将无法通过BMC上电，该锁可被cli命令清除

### 2.4 通电开机策略

- 当服务器发生整机掉电、拔电源、拔板、AC掉电等情况，第一次启动后，bmc可以控制是否给后电部件上电
    
- 当前服务器通电开机策略有三种：保持上电、保持下电、保持AC掉电前的电源状态

### 2.5 高温检测与上电

- 通过监测cpld提供的高温信号，判定当前cpu是否发生了二级mos高温。当发生高温事件时，cpld自动给服务器下后电，fructrl监听到该高温开始计时，5分钟后清除高温事件，并根据配置决定是否给服务器上后电

### 2.6 后电状态与电源突变状态监测

- 真实从cpld获取的后电状态有两种：on和off，但业务操作流程中往往会有上电中oning和下电中offing两种状态，所以fructrl对外展现出4种电源状态—— on/offing（真实cpld表示的后电状态为上电）、off/oning（真实cpld表示的后电状态为下电）
    
- 电源状态突变监测主要应用于异常掉电、异常上电的场景，通过监测后电信号，将控制状态机和热插拔状态机的值处理同步

## 对外接口

### 3.1 资源树接口

#### 3.1.1 上下电控制
| 接口                           | 方法                         | 参数类型 | 参数                                         | 说明                       |
| ------------------------------ | ---------------------------- | -------- | -------------------------------------------- | -------------------------- |
| bmc.kepler.Systems.FruCtrl     | PowerCtrl                    | a{ss}ss      | 1 PowerCtrlType 2 RestartCause                 | 上下电北向接口均调用该接口 |

##### 参数说明

|参数名称     | 参数类型                    | 参数取值|
| ------------------------------ | ---------------------------- |---------------------------- |
| PowerCtrlType    | string  | On 上电、GracefulShutdown 安全下电、ForceOff 强制下电、PowerCycle 安全下电后再上电、ACCycle 整框下电、ForcePowerCycle 强制下电再上电、ForceRestart 强制复位、Nmi 中断     | 
|RestartCause    | string  | Unknown、ChassisControlCommand、ResetViaPushButton等     |

#### 3.1.2 设置额外通电开机策略

| 接口                           | 方法                         | 参数类型 | 参数                                         | 说明                       |
| ------------------------------ | ---------------------------- | -------- | -------------------------------------------- | -------------------------- |
| bmc.kepler.Systems.FruCtrl     | SetPowerOnStrategyExceptions | a{ss}sssy    | 1Reason 2Execute 3EffectivePeriod 4 Priority | 设置额外通电开机策略       |

##### 参数说明

|参数名称     | 参数类型                    | 参数取值|
| ------------------------------ | ---------------------------- |---------------------------- |
|Reason    | string  | 设置额外通电开机策略的原因 | 
|Execute    | string  | Yes: 下次重启执行通电开机、No: 下次重启不执行通电开机策略、None: 下次重启清除额外的通电开机策略  |
|EffectivePeriod    | string  | 生效周期 Once 单次、Continuous 永久| 
|Priority    | number  | 优先级 1~10    |

#### 3.1.3 设置闪断状态

| 接口                           | 方法                         | 参数类型 | 参数                                         | 说明                       |
| ------------------------------ | ---------------------------- | -------- | -------------------------------------------- | -------------------------- |
| bmc.kepler.Systems.FruCtrl | SetACLost    | a{ss}y     | type       | 设置电源闪断状态           |

##### 参数说明

|参数名称     | 参数类型                    | 参数取值|
| ------------------------------ | ---------------------------- |---------------------------- |
|type    | number  | 1 发生电源闪断状态| 

#### 3.1.4 设置上电锁

| 接口                           | 方法                         | 参数类型 | 参数                                         | 说明                       |
| ------------------------------ | ---------------------------- | -------- | -------------------------------------------- | -------------------------- |
| bmc.kepler.Systems.PowerOnLock | SetPowerOnLock    | a{ss}buss     | 1PwrOnLocked 2Timeout 3AppName 4Reason       | 设置上电锁           |

##### 参数说明

|参数名称     | 参数类型                    | 参数取值|
| ------------------------------ | ---------------------------- |---------------------------- |
|PwrOnLocked    | boolean  | true: 锁定 、false: 解锁| 
|Timeout    | number  | 10~3600,单位秒  |
|AppName    | string  | 设置上电锁的App名称| 
|Reason    | string  | 限制上电的原因    |

#### 3.1.5 整机上下电控制

| 接口                           | 方法                         | 参数类型 | 参数                                         | 说明                       |
| ------------------------------ | ---------------------------- | -------- | -------------------------------------------- | -------------------------- |
| bmc.kepler.Chassis.FruCtrl | PowerCtrl    | a{ss}ss     | 1PowerCtrlType 2RestartCause   | 整机上下电      |

##### 参数说明

|参数名称     | 参数类型                    | 参数取值|
| ------------------------------ | ---------------------------- |---------------------------- |
| PowerCtrlType    | string  | On 整机上电、GracefulShutdown 整机安全下电、ForceOff 整机强制下电、PowerCycle 整机安全下电后再上电、ACCycle 整机AC掉电、ForcePowerCycle 整机强制下电再上电、ForceRestart 整机强制复位、Nmi 中断     | 
|RestartCause    | string  | Unknown、ChassisControlCommand、ResetViaPushButton等     |

#### 3.1.6 设置整机上电锁

| 接口                           | 方法                         | 参数类型 | 参数                                         | 说明                       |
| ------------------------------ | ---------------------------- | -------- | -------------------------------------------- | -------------------------- |
| bmc.kepler.Chassis.PowerOnLock | SetPowerOnLock   | a{ss}buss     | 1PwrOnLocked 2Timeout 3AppName 4Reason    | 设置整机上电锁      |

##### 参数说明

|参数名称     | 参数类型                    | 参数取值|
| ------------------------------ | ---------------------------- |---------------------------- |
|PwrOnLocked    | boolean  | true: 锁定 /false: 解锁| 
|Timeout    | number  | 10~3600,单位秒  |
|AppName    | string  | 设置上电锁的App名称| 
|Reason    | string  | 上电限制条件的描述    |

#### 3.1.7 设置整机额外通电开机策略

| 接口                           | 方法                         | 参数类型 | 参数                                         | 说明                       |
| ------------------------------ | ---------------------------- | -------- | -------------------------------------------- | -------------------------- |
| bmc.kepler.Chassis.PowerOnLock     | SetPowerOnStrategyExceptions | a{ss}sssy    | 1Reason 2Execute 3EffectivePeriod 4 Priority | 设置额外通电开机策略       |

##### 参数说明

|参数名称     | 参数类型                    | 参数取值|
| ------------------------------ | ---------------------------- |---------------------------- |
|Reason    | string  | 设置整机额外通电开机策略的原因 | 
|Execute    | string  | Yes: 下次重启执行通电开机、No: 下次重启不执行通电开机策略、None: 下次重启清除额外的通电开机策略  |
|EffectivePeriod    | string  | 生效周期 Once 单次、Continuous 永久| 
|Priority    | number  | 优先级 1~10    |

### 3.2 ipmi接口

| 命令                           | 功能                        | 
| ------------------------------ | ---------------------------- | 
| SetPowerCmd     | 上下电接口(标准命令)                   | 
| SetACLostStatus     | 设置上次电源状态                   | 
| GetACLostStatus     | 获取上次电源状态                  | 
| SetButtonShieldState     | 设置电源按钮防误触功能                 | 
| GetButtonShieldState     | 获取电源按钮防误触功能使能状态                  | 
| SetRestorePolicy    | 设置和查询通电开机策略(标准命令)                 | 
| SetCycleInterval     | 设置cycle的延时时间                   | 
| OEMGetRestartCause     | 获取系统重启原因                  | 
| CMDGetRestartCause     | 获取系统重启原因                 | 
| SetPowerLevel     | 根据POWER_LEVEL执行不同上下电动作                   | 
| GetPowerLevel     | 获取POWER_LEVEL属性                | 
| CmdFruCtrl     | 上下电接口                   | 
| SetFruActivation     | 对系统上下电                   | 
| GetFruActivationPolicy     | 获取fru激活策略                  | 
| SetFruActivationPolicy     | 设置fru激活策略                   | 

## 配置介绍

以下是一个示例,用于实现上下电功能的必备对象

- FruCtrl对象，上下电功能核心的对象
```
"FruCtrl_1_0": {
    "Id": "${SystemId}"
}
```

- PGSignal对象，表示真实后电电源信号
```
"PGSignal_1": {
    "PowerGDState": 1
}
```

- PowerButton对象，表示长按还是短按
```
"PowerButton_1": {
    "ShortPushButton": 0,
    "LongPushButton": 0
}
```

- ACCycle对象，当该对象正常分发时，才支持ac命令
```
"ACCycle_1": {
    "AC": 0
}
```

- ForceReset对象，当该对象正常分发时，才支持强制复位命令
```
"ForceReset_1": {
    "ForceRst": 0
}
```

- SysReset对象，复位信号对象，上报os重启事件时需要该对象
```
"SysReset_1": {
    "GetSysRstDetected": 0,
    "SetSysRstDetected": 0
}
```