-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: I2cLed Service，用于控制不需要用户管理的I2C控制的Led灯
local class = require 'mc.class'
local skynet = require 'skynet'
local log = require 'mc.logging'
local c_led_i2c_object = require 'led_i2c_object'

local c_led_i2c_service = class()

function c_led_i2c_service:add_object(mds_obj, position)
    local obj = c_led_i2c_object.new(mds_obj, position)
    self.led_i2c_list[mds_obj.name] = obj
end

function c_led_i2c_service:task_i2c_led()
    skynet.fork_loop({count = 0}, function ()
        log:debug('[led] led controlled through i2c blink task start.')
        while true do
            if self.is_dft_testing then
                skynet.sleep(100) -- 1s
                goto next
            end
            for _, obj in pairs(self.led_i2c_list) do
                obj:blink_scan()
            end
            skynet.sleep(10) -- 100ms
            ::next::
        end
    end)
end

function c_led_i2c_service:init()
    self.is_dft_testing = false -- 是否正在执行装备测试
end

function c_led_i2c_service:ctor()
    self.led_i2c_list = {}
end

return c_led_i2c_service