-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftLedIntelligence = {}

---@class MDftLedIntelligence.DftEnable
---@field DftEnable integer
local TDftEnable = {}
TDftEnable.__index = TDftEnable
TDftEnable.group = {}

local function TDftEnable_from_obj(obj)
    return setmetatable(obj, TDftEnable)
end

function TDftEnable.new(DftEnable)
    return TDftEnable_from_obj({DftEnable = DftEnable})
end
---@param obj MDftLedIntelligence.DftEnable
function TDftEnable:init_from_obj(obj)
    self.DftEnable = obj.DftEnable
end

function TDftEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDftEnable.group)
end

TDftEnable.from_obj = TDftEnable_from_obj

TDftEnable.proto_property = {'DftEnable'}

TDftEnable.default = {0}

TDftEnable.struct = {{name = 'DftEnable', is_array = false, struct = nil}}

function TDftEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DftEnable', self.DftEnable, 'uint8', false, errs, need_convert)

    TDftEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDftEnable.proto_property, errs, need_convert)
    return self
end

function TDftEnable:unpack(_)
    return self.DftEnable
end

MDftLedIntelligence.DftEnable = TDftEnable

return MDftLedIntelligence
