-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SystemHealth = {}

---@class SystemHealth.SeverityReferenceSource
---@field SeverityReferenceSource string
local TSeverityReferenceSource = {}
TSeverityReferenceSource.__index = TSeverityReferenceSource
TSeverityReferenceSource.group = {}

local function TSeverityReferenceSource_from_obj(obj)
    return setmetatable(obj, TSeverityReferenceSource)
end

function TSeverityReferenceSource.new(SeverityReferenceSource)
    return TSeverityReferenceSource_from_obj({SeverityReferenceSource = SeverityReferenceSource or [=[Event]=]})
end
---@param obj SystemHealth.SeverityReferenceSource
function TSeverityReferenceSource:init_from_obj(obj)
    self.SeverityReferenceSource = obj.SeverityReferenceSource or [=[Event]=]
end

function TSeverityReferenceSource:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSeverityReferenceSource.group)
end

TSeverityReferenceSource.from_obj = TSeverityReferenceSource_from_obj

TSeverityReferenceSource.proto_property = {'SeverityReferenceSource'}

TSeverityReferenceSource.default = {''}

TSeverityReferenceSource.struct = {{name = 'SeverityReferenceSource', is_array = false, struct = nil}}

function TSeverityReferenceSource:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SeverityReferenceSource', self.SeverityReferenceSource, 'string', false, errs,
        need_convert)

    if self.SeverityReferenceSource ~= nil then
        validate.Enum(prefix .. 'SeverityReferenceSource', self.SeverityReferenceSource, '',
            {'Event', 'Sensor', 'EventAndSensor'}, errs, need_convert)
    end

    TSeverityReferenceSource:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSeverityReferenceSource.proto_property, errs, need_convert)
    return self
end

function TSeverityReferenceSource:unpack(_)
    return self.SeverityReferenceSource
end

SystemHealth.SeverityReferenceSource = TSeverityReferenceSource

SystemHealth.interface = mdb.register_interface('bmc.kepler.Systems.Led.Policy.SystemHealth',
    {SeverityReferenceSource = {'s', {}, false, 'Event'}}, {}, {})

return SystemHealth
