-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SuperPodLabel = {}

---@class SuperPodLabel.SuperPodEnabled
---@field SuperPodEnabled boolean
local TSuperPodEnabled = {}
TSuperPodEnabled.__index = TSuperPodEnabled
TSuperPodEnabled.group = {}

local function TSuperPodEnabled_from_obj(obj)
    return setmetatable(obj, TSuperPodEnabled)
end

function TSuperPodEnabled.new(SuperPodEnabled)
    return TSuperPodEnabled_from_obj({SuperPodEnabled = SuperPodEnabled or false})
end
---@param obj SuperPodLabel.SuperPodEnabled
function TSuperPodEnabled:init_from_obj(obj)
    self.SuperPodEnabled = obj.SuperPodEnabled or false
end

function TSuperPodEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSuperPodEnabled.group)
end

TSuperPodEnabled.from_obj = TSuperPodEnabled_from_obj

TSuperPodEnabled.proto_property = {'SuperPodEnabled'}

TSuperPodEnabled.default = {false}

TSuperPodEnabled.struct = {{name = 'SuperPodEnabled', is_array = false, struct = nil}}

function TSuperPodEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodEnabled', self.SuperPodEnabled, 'bool', true, errs, need_convert)

    TSuperPodEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSuperPodEnabled.proto_property, errs, need_convert)
    return self
end

function TSuperPodEnabled:unpack(_)
    return self.SuperPodEnabled
end

SuperPodLabel.SuperPodEnabled = TSuperPodEnabled

---@class SuperPodLabel.SuperPodSize
---@field SuperPodSize integer
local TSuperPodSize = {}
TSuperPodSize.__index = TSuperPodSize
TSuperPodSize.group = {}

local function TSuperPodSize_from_obj(obj)
    return setmetatable(obj, TSuperPodSize)
end

function TSuperPodSize.new(SuperPodSize)
    return TSuperPodSize_from_obj({SuperPodSize = SuperPodSize or 384})
end
---@param obj SuperPodLabel.SuperPodSize
function TSuperPodSize:init_from_obj(obj)
    self.SuperPodSize = obj.SuperPodSize or 384
end

function TSuperPodSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSuperPodSize.group)
end

TSuperPodSize.from_obj = TSuperPodSize_from_obj

TSuperPodSize.proto_property = {'SuperPodSize'}

TSuperPodSize.default = {0}

TSuperPodSize.struct = {{name = 'SuperPodSize', is_array = false, struct = nil}}

function TSuperPodSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodSize', self.SuperPodSize, 'uint16', true, errs, need_convert)

    if self.SuperPodSize ~= nil then
        validate.ranges(prefix .. 'SuperPodSize', self.SuperPodSize, 1, 384, errs, need_convert)
    end

    TSuperPodSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSuperPodSize.proto_property, errs, need_convert)
    return self
end

function TSuperPodSize:unpack(_)
    return self.SuperPodSize
end

SuperPodLabel.SuperPodSize = TSuperPodSize

---@class SuperPodLabel.ServerIndex
---@field ServerIndex integer
local TServerIndex = {}
TServerIndex.__index = TServerIndex
TServerIndex.group = {}

local function TServerIndex_from_obj(obj)
    return setmetatable(obj, TServerIndex)
end

function TServerIndex.new(ServerIndex)
    return TServerIndex_from_obj({ServerIndex = ServerIndex or 65535})
end
---@param obj SuperPodLabel.ServerIndex
function TServerIndex:init_from_obj(obj)
    self.ServerIndex = obj.ServerIndex or 65535
end

function TServerIndex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TServerIndex.group)
end

TServerIndex.from_obj = TServerIndex_from_obj

TServerIndex.proto_property = {'ServerIndex'}

TServerIndex.default = {0}

TServerIndex.struct = {{name = 'ServerIndex', is_array = false, struct = nil}}

function TServerIndex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ServerIndex', self.ServerIndex, 'uint16', true, errs, need_convert)

    TServerIndex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TServerIndex.proto_property, errs, need_convert)
    return self
end

function TServerIndex:unpack(_)
    return self.ServerIndex
end

SuperPodLabel.ServerIndex = TServerIndex

---@class SuperPodLabel.SuperPodId
---@field SuperPodId integer
local TSuperPodId = {}
TSuperPodId.__index = TSuperPodId
TSuperPodId.group = {}

local function TSuperPodId_from_obj(obj)
    return setmetatable(obj, TSuperPodId)
end

function TSuperPodId.new(SuperPodId)
    return TSuperPodId_from_obj({SuperPodId = SuperPodId or 4294967295})
end
---@param obj SuperPodLabel.SuperPodId
function TSuperPodId:init_from_obj(obj)
    self.SuperPodId = obj.SuperPodId or 4294967295
end

function TSuperPodId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSuperPodId.group)
end

TSuperPodId.from_obj = TSuperPodId_from_obj

TSuperPodId.proto_property = {'SuperPodId'}

TSuperPodId.default = {0}

TSuperPodId.struct = {{name = 'SuperPodId', is_array = false, struct = nil}}

function TSuperPodId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodId', self.SuperPodId, 'uint32', true, errs, need_convert)

    TSuperPodId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSuperPodId.proto_property, errs, need_convert)
    return self
end

function TSuperPodId:unpack(_)
    return self.SuperPodId
end

SuperPodLabel.SuperPodId = TSuperPodId

---@class SuperPodLabel.RestoreDefaultsRsp
---@field Result boolean
local TRestoreDefaultsRsp = {}
TRestoreDefaultsRsp.__index = TRestoreDefaultsRsp
TRestoreDefaultsRsp.group = {}

local function TRestoreDefaultsRsp_from_obj(obj)
    return setmetatable(obj, TRestoreDefaultsRsp)
end

function TRestoreDefaultsRsp.new(Result)
    return TRestoreDefaultsRsp_from_obj({Result = Result})
end
---@param obj SuperPodLabel.RestoreDefaultsRsp
function TRestoreDefaultsRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TRestoreDefaultsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestoreDefaultsRsp.group)
end

TRestoreDefaultsRsp.from_obj = TRestoreDefaultsRsp_from_obj

TRestoreDefaultsRsp.proto_property = {'Result'}

TRestoreDefaultsRsp.default = {false}

TRestoreDefaultsRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TRestoreDefaultsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'bool', false, errs, need_convert)

    TRestoreDefaultsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestoreDefaultsRsp.proto_property, errs, need_convert)
    return self
end

function TRestoreDefaultsRsp:unpack(_)
    return self.Result
end

SuperPodLabel.RestoreDefaultsRsp = TRestoreDefaultsRsp

---@class SuperPodLabel.RestoreDefaultsReq
local TRestoreDefaultsReq = {}
TRestoreDefaultsReq.__index = TRestoreDefaultsReq
TRestoreDefaultsReq.group = {}

local function TRestoreDefaultsReq_from_obj(obj)
    return setmetatable(obj, TRestoreDefaultsReq)
end

function TRestoreDefaultsReq.new()
    return TRestoreDefaultsReq_from_obj({})
end
---@param obj SuperPodLabel.RestoreDefaultsReq
function TRestoreDefaultsReq:init_from_obj(obj)

end

function TRestoreDefaultsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestoreDefaultsReq.group)
end

TRestoreDefaultsReq.from_obj = TRestoreDefaultsReq_from_obj

TRestoreDefaultsReq.proto_property = {}

TRestoreDefaultsReq.default = {}

TRestoreDefaultsReq.struct = {}

function TRestoreDefaultsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRestoreDefaultsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestoreDefaultsReq.proto_property, errs, need_convert)
    return self
end

function TRestoreDefaultsReq:unpack(_)
end

SuperPodLabel.RestoreDefaultsReq = TRestoreDefaultsReq

---@class SuperPodLabel.SetSuperPodEnabledRsp
local TSetSuperPodEnabledRsp = {}
TSetSuperPodEnabledRsp.__index = TSetSuperPodEnabledRsp
TSetSuperPodEnabledRsp.group = {}

local function TSetSuperPodEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetSuperPodEnabledRsp)
end

function TSetSuperPodEnabledRsp.new()
    return TSetSuperPodEnabledRsp_from_obj({})
end
---@param obj SuperPodLabel.SetSuperPodEnabledRsp
function TSetSuperPodEnabledRsp:init_from_obj(obj)

end

function TSetSuperPodEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodEnabledRsp.group)
end

TSetSuperPodEnabledRsp.from_obj = TSetSuperPodEnabledRsp_from_obj

TSetSuperPodEnabledRsp.proto_property = {}

TSetSuperPodEnabledRsp.default = {}

TSetSuperPodEnabledRsp.struct = {}

function TSetSuperPodEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSuperPodEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodEnabledRsp:unpack(_)
end

SuperPodLabel.SetSuperPodEnabledRsp = TSetSuperPodEnabledRsp

---@class SuperPodLabel.SetSuperPodEnabledReq
---@field SuperPodEnabled boolean
local TSetSuperPodEnabledReq = {}
TSetSuperPodEnabledReq.__index = TSetSuperPodEnabledReq
TSetSuperPodEnabledReq.group = {}

local function TSetSuperPodEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetSuperPodEnabledReq)
end

function TSetSuperPodEnabledReq.new(SuperPodEnabled)
    return TSetSuperPodEnabledReq_from_obj({SuperPodEnabled = SuperPodEnabled})
end
---@param obj SuperPodLabel.SetSuperPodEnabledReq
function TSetSuperPodEnabledReq:init_from_obj(obj)
    self.SuperPodEnabled = obj.SuperPodEnabled
end

function TSetSuperPodEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodEnabledReq.group)
end

TSetSuperPodEnabledReq.from_obj = TSetSuperPodEnabledReq_from_obj

TSetSuperPodEnabledReq.proto_property = {'SuperPodEnabled'}

TSetSuperPodEnabledReq.default = {false}

TSetSuperPodEnabledReq.struct = {{name = 'SuperPodEnabled', is_array = false, struct = nil}}

function TSetSuperPodEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodEnabled', self.SuperPodEnabled, 'bool', false, errs, need_convert)

    TSetSuperPodEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodEnabledReq.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodEnabledReq:unpack(_)
    return self.SuperPodEnabled
end

SuperPodLabel.SetSuperPodEnabledReq = TSetSuperPodEnabledReq

---@class SuperPodLabel.SetSuperPodSizeRsp
---@field Result boolean
local TSetSuperPodSizeRsp = {}
TSetSuperPodSizeRsp.__index = TSetSuperPodSizeRsp
TSetSuperPodSizeRsp.group = {}

local function TSetSuperPodSizeRsp_from_obj(obj)
    return setmetatable(obj, TSetSuperPodSizeRsp)
end

function TSetSuperPodSizeRsp.new(Result)
    return TSetSuperPodSizeRsp_from_obj({Result = Result})
end
---@param obj SuperPodLabel.SetSuperPodSizeRsp
function TSetSuperPodSizeRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetSuperPodSizeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodSizeRsp.group)
end

TSetSuperPodSizeRsp.from_obj = TSetSuperPodSizeRsp_from_obj

TSetSuperPodSizeRsp.proto_property = {'Result'}

TSetSuperPodSizeRsp.default = {false}

TSetSuperPodSizeRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetSuperPodSizeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'bool', false, errs, need_convert)

    TSetSuperPodSizeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodSizeRsp.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodSizeRsp:unpack(_)
    return self.Result
end

SuperPodLabel.SetSuperPodSizeRsp = TSetSuperPodSizeRsp

---@class SuperPodLabel.SetSuperPodSizeReq
---@field SuperPodSize integer
local TSetSuperPodSizeReq = {}
TSetSuperPodSizeReq.__index = TSetSuperPodSizeReq
TSetSuperPodSizeReq.group = {}

local function TSetSuperPodSizeReq_from_obj(obj)
    return setmetatable(obj, TSetSuperPodSizeReq)
end

function TSetSuperPodSizeReq.new(SuperPodSize)
    return TSetSuperPodSizeReq_from_obj({SuperPodSize = SuperPodSize})
end
---@param obj SuperPodLabel.SetSuperPodSizeReq
function TSetSuperPodSizeReq:init_from_obj(obj)
    self.SuperPodSize = obj.SuperPodSize
end

function TSetSuperPodSizeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodSizeReq.group)
end

TSetSuperPodSizeReq.from_obj = TSetSuperPodSizeReq_from_obj

TSetSuperPodSizeReq.proto_property = {'SuperPodSize'}

TSetSuperPodSizeReq.default = {0}

TSetSuperPodSizeReq.struct = {{name = 'SuperPodSize', is_array = false, struct = nil}}

function TSetSuperPodSizeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodSize', self.SuperPodSize, 'uint16', false, errs, need_convert)

    TSetSuperPodSizeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodSizeReq.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodSizeReq:unpack(_)
    return self.SuperPodSize
end

SuperPodLabel.SetSuperPodSizeReq = TSetSuperPodSizeReq

---@class SuperPodLabel.SetServerIndexRsp
---@field Result boolean
local TSetServerIndexRsp = {}
TSetServerIndexRsp.__index = TSetServerIndexRsp
TSetServerIndexRsp.group = {}

local function TSetServerIndexRsp_from_obj(obj)
    return setmetatable(obj, TSetServerIndexRsp)
end

function TSetServerIndexRsp.new(Result)
    return TSetServerIndexRsp_from_obj({Result = Result})
end
---@param obj SuperPodLabel.SetServerIndexRsp
function TSetServerIndexRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetServerIndexRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetServerIndexRsp.group)
end

TSetServerIndexRsp.from_obj = TSetServerIndexRsp_from_obj

TSetServerIndexRsp.proto_property = {'Result'}

TSetServerIndexRsp.default = {false}

TSetServerIndexRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetServerIndexRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'bool', false, errs, need_convert)

    TSetServerIndexRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetServerIndexRsp.proto_property, errs, need_convert)
    return self
end

function TSetServerIndexRsp:unpack(_)
    return self.Result
end

SuperPodLabel.SetServerIndexRsp = TSetServerIndexRsp

---@class SuperPodLabel.SetServerIndexReq
---@field ServerIndex integer
local TSetServerIndexReq = {}
TSetServerIndexReq.__index = TSetServerIndexReq
TSetServerIndexReq.group = {}

local function TSetServerIndexReq_from_obj(obj)
    return setmetatable(obj, TSetServerIndexReq)
end

function TSetServerIndexReq.new(ServerIndex)
    return TSetServerIndexReq_from_obj({ServerIndex = ServerIndex})
end
---@param obj SuperPodLabel.SetServerIndexReq
function TSetServerIndexReq:init_from_obj(obj)
    self.ServerIndex = obj.ServerIndex
end

function TSetServerIndexReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetServerIndexReq.group)
end

TSetServerIndexReq.from_obj = TSetServerIndexReq_from_obj

TSetServerIndexReq.proto_property = {'ServerIndex'}

TSetServerIndexReq.default = {0}

TSetServerIndexReq.struct = {{name = 'ServerIndex', is_array = false, struct = nil}}

function TSetServerIndexReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ServerIndex', self.ServerIndex, 'uint16', false, errs, need_convert)

    TSetServerIndexReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetServerIndexReq.proto_property, errs, need_convert)
    return self
end

function TSetServerIndexReq:unpack(_)
    return self.ServerIndex
end

SuperPodLabel.SetServerIndexReq = TSetServerIndexReq

---@class SuperPodLabel.SetSuperPodIdRsp
---@field Result boolean
local TSetSuperPodIdRsp = {}
TSetSuperPodIdRsp.__index = TSetSuperPodIdRsp
TSetSuperPodIdRsp.group = {}

local function TSetSuperPodIdRsp_from_obj(obj)
    return setmetatable(obj, TSetSuperPodIdRsp)
end

function TSetSuperPodIdRsp.new(Result)
    return TSetSuperPodIdRsp_from_obj({Result = Result})
end
---@param obj SuperPodLabel.SetSuperPodIdRsp
function TSetSuperPodIdRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetSuperPodIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodIdRsp.group)
end

TSetSuperPodIdRsp.from_obj = TSetSuperPodIdRsp_from_obj

TSetSuperPodIdRsp.proto_property = {'Result'}

TSetSuperPodIdRsp.default = {false}

TSetSuperPodIdRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetSuperPodIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'bool', false, errs, need_convert)

    TSetSuperPodIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodIdRsp.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodIdRsp:unpack(_)
    return self.Result
end

SuperPodLabel.SetSuperPodIdRsp = TSetSuperPodIdRsp

---@class SuperPodLabel.SetSuperPodIdReq
---@field SuperPodId integer
local TSetSuperPodIdReq = {}
TSetSuperPodIdReq.__index = TSetSuperPodIdReq
TSetSuperPodIdReq.group = {}

local function TSetSuperPodIdReq_from_obj(obj)
    return setmetatable(obj, TSetSuperPodIdReq)
end

function TSetSuperPodIdReq.new(SuperPodId)
    return TSetSuperPodIdReq_from_obj({SuperPodId = SuperPodId})
end
---@param obj SuperPodLabel.SetSuperPodIdReq
function TSetSuperPodIdReq:init_from_obj(obj)
    self.SuperPodId = obj.SuperPodId
end

function TSetSuperPodIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodIdReq.group)
end

TSetSuperPodIdReq.from_obj = TSetSuperPodIdReq_from_obj

TSetSuperPodIdReq.proto_property = {'SuperPodId'}

TSetSuperPodIdReq.default = {0}

TSetSuperPodIdReq.struct = {{name = 'SuperPodId', is_array = false, struct = nil}}

function TSetSuperPodIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SuperPodId', self.SuperPodId, 'uint32', false, errs, need_convert)

    TSetSuperPodIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodIdReq.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodIdReq:unpack(_)
    return self.SuperPodId
end

SuperPodLabel.SetSuperPodIdReq = TSetSuperPodIdReq

SuperPodLabel.interface = mdb.register_interface('bmc.kepler.Chassis.SuperPodLabel', {
    SuperPodId = {'u', {'EMIT_CHANGE'}, true, 4294967295},
    ServerIndex = {'q', {'EMIT_CHANGE'}, true, 65535},
    SuperPodSize = {'q', {'EMIT_CHANGE'}, true, 384},
    SuperPodEnabled = {'b', {'EMIT_CHANGE'}, true, false}
}, {
    SetSuperPodId = {'a{ss}u', 'b', TSetSuperPodIdReq, TSetSuperPodIdRsp},
    SetServerIndex = {'a{ss}q', 'b', TSetServerIndexReq, TSetServerIndexRsp},
    SetSuperPodSize = {'a{ss}q', 'b', TSetSuperPodSizeReq, TSetSuperPodSizeRsp},
    SetSuperPodEnabled = {'a{ss}b', '', TSetSuperPodEnabledReq, TSetSuperPodEnabledRsp},
    RestoreDefaults = {'a{ss}', 'b', TRestoreDefaultsReq, TRestoreDefaultsRsp}
}, {})

return SuperPodLabel
