-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Status = {}

---@class Status.SetAlarmLatchRsp
local TSetAlarmLatchRsp = {}
TSetAlarmLatchRsp.__index = TSetAlarmLatchRsp
TSetAlarmLatchRsp.group = {}

local function TSetAlarmLatchRsp_from_obj(obj)
    return setmetatable(obj, TSetAlarmLatchRsp)
end

function TSetAlarmLatchRsp.new()
    return TSetAlarmLatchRsp_from_obj({})
end
---@param obj Status.SetAlarmLatchRsp
function TSetAlarmLatchRsp:init_from_obj(obj)

end

function TSetAlarmLatchRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAlarmLatchRsp.group)
end

TSetAlarmLatchRsp.from_obj = TSetAlarmLatchRsp_from_obj

TSetAlarmLatchRsp.proto_property = {}

TSetAlarmLatchRsp.default = {}

TSetAlarmLatchRsp.struct = {}

function TSetAlarmLatchRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetAlarmLatchRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAlarmLatchRsp.proto_property, errs, need_convert)
    return self
end

function TSetAlarmLatchRsp:unpack(_)
end

Status.SetAlarmLatchRsp = TSetAlarmLatchRsp

---@class Status.SetAlarmLatchReq
---@field SwitchStatus integer
local TSetAlarmLatchReq = {}
TSetAlarmLatchReq.__index = TSetAlarmLatchReq
TSetAlarmLatchReq.group = {}

local function TSetAlarmLatchReq_from_obj(obj)
    return setmetatable(obj, TSetAlarmLatchReq)
end

function TSetAlarmLatchReq.new(SwitchStatus)
    return TSetAlarmLatchReq_from_obj({SwitchStatus = SwitchStatus})
end
---@param obj Status.SetAlarmLatchReq
function TSetAlarmLatchReq:init_from_obj(obj)
    self.SwitchStatus = obj.SwitchStatus
end

function TSetAlarmLatchReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAlarmLatchReq.group)
end

TSetAlarmLatchReq.from_obj = TSetAlarmLatchReq_from_obj

TSetAlarmLatchReq.proto_property = {'SwitchStatus'}

TSetAlarmLatchReq.default = {0}

TSetAlarmLatchReq.struct = {{name = 'SwitchStatus', is_array = false, struct = nil}}

function TSetAlarmLatchReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SwitchStatus', self.SwitchStatus, 'uint8', false, errs, need_convert)

    if self.SwitchStatus ~= nil then
        validate.Enum(prefix .. 'SwitchStatus', self.SwitchStatus, '', {0, 1}, errs, need_convert)
    end

    TSetAlarmLatchReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAlarmLatchReq.proto_property, errs, need_convert)
    return self
end

function TSetAlarmLatchReq:unpack(_)
    return self.SwitchStatus
end

Status.SetAlarmLatchReq = TSetAlarmLatchReq

---@class Status.SetSleepModeRsp
---@field CmdResult integer
local TSetSleepModeRsp = {}
TSetSleepModeRsp.__index = TSetSleepModeRsp
TSetSleepModeRsp.group = {}

local function TSetSleepModeRsp_from_obj(obj)
    return setmetatable(obj, TSetSleepModeRsp)
end

function TSetSleepModeRsp.new(CmdResult)
    return TSetSleepModeRsp_from_obj({CmdResult = CmdResult})
end
---@param obj Status.SetSleepModeRsp
function TSetSleepModeRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetSleepModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSleepModeRsp.group)
end

TSetSleepModeRsp.from_obj = TSetSleepModeRsp_from_obj

TSetSleepModeRsp.proto_property = {'CmdResult'}

TSetSleepModeRsp.default = {0}

TSetSleepModeRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetSleepModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint8', false, errs, need_convert)

    TSetSleepModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSleepModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetSleepModeRsp:unpack(_)
    return self.CmdResult
end

Status.SetSleepModeRsp = TSetSleepModeRsp

---@class Status.SetSleepModeReq
---@field SleepMode string
local TSetSleepModeReq = {}
TSetSleepModeReq.__index = TSetSleepModeReq
TSetSleepModeReq.group = {}

local function TSetSleepModeReq_from_obj(obj)
    return setmetatable(obj, TSetSleepModeReq)
end

function TSetSleepModeReq.new(SleepMode)
    return TSetSleepModeReq_from_obj({SleepMode = SleepMode})
end
---@param obj Status.SetSleepModeReq
function TSetSleepModeReq:init_from_obj(obj)
    self.SleepMode = obj.SleepMode
end

function TSetSleepModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSleepModeReq.group)
end

TSetSleepModeReq.from_obj = TSetSleepModeReq_from_obj

TSetSleepModeReq.proto_property = {'SleepMode'}

TSetSleepModeReq.default = {''}

TSetSleepModeReq.struct = {{name = 'SleepMode', is_array = false, struct = nil}}

function TSetSleepModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SleepMode', self.SleepMode, 'string', false, errs, need_convert)

    TSetSleepModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSleepModeReq.proto_property, errs, need_convert)
    return self
end

function TSetSleepModeReq:unpack(_)
    return self.SleepMode
end

Status.SetSleepModeReq = TSetSleepModeReq

Status.interface = mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower.Status', {
    Health = {'y', nil, true, 255},
    IsUpgrading = {'b', nil, true, nil},
    OutputState = {'y', nil, true, nil},
    NormalAndRedundancySupported = {'b', nil, true, nil},
    SleepMode = {'s', nil, true, nil},
    InputVoltageFault = {'q', nil, true, 32768},
    OutputVoltageFault = {'y', nil, true, nil},
    OutputCurrentFault = {'y', nil, true, nil},
    FanFault = {'y', nil, true, nil},
    Fan1Fault = {'y', nil, true, nil},
    Fan2Fault = {'y', nil, true, nil},
    OverTemperature = {'y', nil, true, nil},
    Failure = {'y', nil, true, nil},
    LossOfInput = {'y', nil, true, nil},
    DeepSleepEnabled = {'y', nil, true, nil},
    ScanStatus = {'y', nil, true, nil},
    InputVoltageStatus = {'y', nil, true, nil},
    DualInputVoltageStatus = {'q', nil, true, nil},
    CommunicationStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, nil},
    MfrSpecificStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, 255},
    EquipmentMode = {'y', {['emitsChangedSignal'] = 'true'}, true, 255},
    CMLStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, nil},
    OtherStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, nil},
    TPSUStatusHigh = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    TPSUStatusLow = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    MainCircuitVINStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, nil},
    BackupCircuitVINStatus = {'y', {['emitsChangedSignal'] = 'true'}, true, nil}
}, {
    SetSleepMode = {'a{ss}s', 'y', TSetSleepModeReq, TSetSleepModeRsp},
    SetAlarmLatch = {'a{ss}y', '', TSetAlarmLatchReq, TSetAlarmLatchRsp}
}, {})

return Status
