-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local OnePower = {}

---@class OnePower.SetPowerSupplyCircuitRsp
local TSetPowerSupplyCircuitRsp = {}
TSetPowerSupplyCircuitRsp.__index = TSetPowerSupplyCircuitRsp
TSetPowerSupplyCircuitRsp.group = {}

local function TSetPowerSupplyCircuitRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerSupplyCircuitRsp)
end

function TSetPowerSupplyCircuitRsp.new()
    return TSetPowerSupplyCircuitRsp_from_obj({})
end
---@param obj OnePower.SetPowerSupplyCircuitRsp
function TSetPowerSupplyCircuitRsp:init_from_obj(obj)

end

function TSetPowerSupplyCircuitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerSupplyCircuitRsp.group)
end

TSetPowerSupplyCircuitRsp.from_obj = TSetPowerSupplyCircuitRsp_from_obj

TSetPowerSupplyCircuitRsp.proto_property = {}

TSetPowerSupplyCircuitRsp.default = {}

TSetPowerSupplyCircuitRsp.struct = {}

function TSetPowerSupplyCircuitRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPowerSupplyCircuitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerSupplyCircuitRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerSupplyCircuitRsp:unpack(_)
end

OnePower.SetPowerSupplyCircuitRsp = TSetPowerSupplyCircuitRsp

---@class OnePower.SetPowerSupplyCircuitReq
---@field PowerSupplyCircuit integer
local TSetPowerSupplyCircuitReq = {}
TSetPowerSupplyCircuitReq.__index = TSetPowerSupplyCircuitReq
TSetPowerSupplyCircuitReq.group = {}

local function TSetPowerSupplyCircuitReq_from_obj(obj)
    return setmetatable(obj, TSetPowerSupplyCircuitReq)
end

function TSetPowerSupplyCircuitReq.new(PowerSupplyCircuit)
    return TSetPowerSupplyCircuitReq_from_obj({PowerSupplyCircuit = PowerSupplyCircuit})
end
---@param obj OnePower.SetPowerSupplyCircuitReq
function TSetPowerSupplyCircuitReq:init_from_obj(obj)
    self.PowerSupplyCircuit = obj.PowerSupplyCircuit
end

function TSetPowerSupplyCircuitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerSupplyCircuitReq.group)
end

TSetPowerSupplyCircuitReq.from_obj = TSetPowerSupplyCircuitReq_from_obj

TSetPowerSupplyCircuitReq.proto_property = {'PowerSupplyCircuit'}

TSetPowerSupplyCircuitReq.default = {0}

TSetPowerSupplyCircuitReq.struct = {{name = 'PowerSupplyCircuit', is_array = false, struct = nil}}

function TSetPowerSupplyCircuitReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerSupplyCircuit', self.PowerSupplyCircuit, 'uint8', false, errs, need_convert)

    if self.PowerSupplyCircuit ~= nil then
        validate.Enum(prefix .. 'PowerSupplyCircuit', self.PowerSupplyCircuit, '', {0, 1}, errs, need_convert)
    end

    TSetPowerSupplyCircuitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerSupplyCircuitReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerSupplyCircuitReq:unpack(_)
    return self.PowerSupplyCircuit
end

OnePower.SetPowerSupplyCircuitReq = TSetPowerSupplyCircuitReq

---@class OnePower.ResetRsp
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new()
    return TResetRsp_from_obj({})
end
---@param obj OnePower.ResetRsp
function TResetRsp:init_from_obj(obj)

end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {}

TResetRsp.default = {}

TResetRsp.struct = {}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
end

OnePower.ResetRsp = TResetRsp

---@class OnePower.ResetReq
---@field ResetType string
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new(ResetType)
    return TResetReq_from_obj({ResetType = ResetType})
end
---@param obj OnePower.ResetReq
function TResetReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {'ResetType'}

TResetReq.default = {''}

TResetReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'string', false, errs, need_convert)

    if self.ResetType ~= nil then
        validate.Enum(prefix .. 'ResetType', self.ResetType, '',
            {'ForceRestart', 'ForceOff', 'ForceOn', 'On', 'PowerCycle'}, errs, need_convert)
    end

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
    return self.ResetType
end

OnePower.ResetReq = TResetReq

---@class OnePower.SetPowerWorkModeRsp
---@field CmdResult integer
local TSetPowerWorkModeRsp = {}
TSetPowerWorkModeRsp.__index = TSetPowerWorkModeRsp
TSetPowerWorkModeRsp.group = {}

local function TSetPowerWorkModeRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkModeRsp)
end

function TSetPowerWorkModeRsp.new(CmdResult)
    return TSetPowerWorkModeRsp_from_obj({CmdResult = CmdResult})
end
---@param obj OnePower.SetPowerWorkModeRsp
function TSetPowerWorkModeRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetPowerWorkModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkModeRsp.group)
end

TSetPowerWorkModeRsp.from_obj = TSetPowerWorkModeRsp_from_obj

TSetPowerWorkModeRsp.proto_property = {'CmdResult'}

TSetPowerWorkModeRsp.default = {0}

TSetPowerWorkModeRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetPowerWorkModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint8', false, errs, need_convert)

    TSetPowerWorkModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerWorkModeRsp:unpack(_)
    return self.CmdResult
end

OnePower.SetPowerWorkModeRsp = TSetPowerWorkModeRsp

---@class OnePower.SetPowerWorkModeReq
---@field PowerWorkMode integer
local TSetPowerWorkModeReq = {}
TSetPowerWorkModeReq.__index = TSetPowerWorkModeReq
TSetPowerWorkModeReq.group = {}

local function TSetPowerWorkModeReq_from_obj(obj)
    return setmetatable(obj, TSetPowerWorkModeReq)
end

function TSetPowerWorkModeReq.new(PowerWorkMode)
    return TSetPowerWorkModeReq_from_obj({PowerWorkMode = PowerWorkMode})
end
---@param obj OnePower.SetPowerWorkModeReq
function TSetPowerWorkModeReq:init_from_obj(obj)
    self.PowerWorkMode = obj.PowerWorkMode
end

function TSetPowerWorkModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerWorkModeReq.group)
end

TSetPowerWorkModeReq.from_obj = TSetPowerWorkModeReq_from_obj

TSetPowerWorkModeReq.proto_property = {'PowerWorkMode'}

TSetPowerWorkModeReq.default = {0}

TSetPowerWorkModeReq.struct = {{name = 'PowerWorkMode', is_array = false, struct = nil}}

function TSetPowerWorkModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWorkMode', self.PowerWorkMode, 'uint8', false, errs, need_convert)

    TSetPowerWorkModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerWorkModeReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerWorkModeReq:unpack(_)
    return self.PowerWorkMode
end

OnePower.SetPowerWorkModeReq = TSetPowerWorkModeReq

OnePower.interface = mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower', {
    SlotNumber = {'u', nil, true, 0},
    Manufacturer = {'s', nil, true, nil},
    Model = {'s', nil, true, nil},
    PowerSupplyType = {'u', nil, true, 0},
    Presence = {'y', nil, true, 0},
    PowerSupplyChannel = {'y', nil, true, 0},
    SerialNumber = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    Protocol = {'s', nil, true, nil},
    DeviceLocator = {'s', nil, true, nil},
    ProductionDate = {'s', nil, true, nil},
    WorkMode = {'s', nil, true, nil},
    Position = {'s', nil, true, nil},
    TotalRunningHours = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    RedundancyGroupId = {'y', nil, true, nil},
    InputVoltageType = {'y', nil, true, nil},
    DMTFPowerSupplyType = {'y', nil, true, nil},
    SourceType = {'y', nil, true, nil},
    IsPartOfSysPower = {'b', {['emitsChangedSignal'] = 'false'}, true, true},
    LineInputVoltageType = {'s', {['emitsChangedSignal'] = 'false'}, true, 'Unknown'},
    RelaySwitchedCount = {'q', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {
    SetPowerWorkMode = {'a{ss}y', 'y', TSetPowerWorkModeReq, TSetPowerWorkModeRsp},
    Reset = {'a{ss}s', '', TResetReq, TResetRsp},
    SetPowerSupplyCircuit = {'a{ss}y', '', TSetPowerSupplyCircuitReq, TSetPowerSupplyCircuitRsp}
}, {})

return OnePower
