-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NCSICapabilities = {}

---@class NCSICapabilities.PCIeNCSISupported
---@field PCIeNCSISupported boolean
local TPCIeNCSISupported = {}
TPCIeNCSISupported.__index = TPCIeNCSISupported
TPCIeNCSISupported.group = {}

local function TPCIeNCSISupported_from_obj(obj)
    return setmetatable(obj, TPCIeNCSISupported)
end

function TPCIeNCSISupported.new(PCIeNCSISupported)
    return TPCIeNCSISupported_from_obj({PCIeNCSISupported = PCIeNCSISupported})
end
---@param obj NCSICapabilities.PCIeNCSISupported
function TPCIeNCSISupported:init_from_obj(obj)
    self.PCIeNCSISupported = obj.PCIeNCSISupported
end

function TPCIeNCSISupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeNCSISupported.group)
end

TPCIeNCSISupported.from_obj = TPCIeNCSISupported_from_obj

TPCIeNCSISupported.proto_property = {'PCIeNCSISupported'}

TPCIeNCSISupported.default = {false}

TPCIeNCSISupported.struct = {{name = 'PCIeNCSISupported', is_array = false, struct = nil}}

function TPCIeNCSISupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeNCSISupported', self.PCIeNCSISupported, 'bool', true, errs, need_convert)

    TPCIeNCSISupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeNCSISupported.proto_property, errs, need_convert)
    return self
end

function TPCIeNCSISupported:unpack(_)
    return self.PCIeNCSISupported
end

NCSICapabilities.PCIeNCSISupported = TPCIeNCSISupported

---@class NCSICapabilities.PCIeNCSIEnabled
---@field PCIeNCSIEnabled integer
local TPCIeNCSIEnabled = {}
TPCIeNCSIEnabled.__index = TPCIeNCSIEnabled
TPCIeNCSIEnabled.group = {}

local function TPCIeNCSIEnabled_from_obj(obj)
    return setmetatable(obj, TPCIeNCSIEnabled)
end

function TPCIeNCSIEnabled.new(PCIeNCSIEnabled)
    return TPCIeNCSIEnabled_from_obj({PCIeNCSIEnabled = PCIeNCSIEnabled})
end
---@param obj NCSICapabilities.PCIeNCSIEnabled
function TPCIeNCSIEnabled:init_from_obj(obj)
    self.PCIeNCSIEnabled = obj.PCIeNCSIEnabled
end

function TPCIeNCSIEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeNCSIEnabled.group)
end

TPCIeNCSIEnabled.from_obj = TPCIeNCSIEnabled_from_obj

TPCIeNCSIEnabled.proto_property = {'PCIeNCSIEnabled'}

TPCIeNCSIEnabled.default = {0}

TPCIeNCSIEnabled.struct = {{name = 'PCIeNCSIEnabled', is_array = false, struct = nil}}

function TPCIeNCSIEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeNCSIEnabled', self.PCIeNCSIEnabled, 'uint8', true, errs, need_convert)

    TPCIeNCSIEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeNCSIEnabled.proto_property, errs, need_convert)
    return self
end

function TPCIeNCSIEnabled:unpack(_)
    return self.PCIeNCSIEnabled
end

NCSICapabilities.PCIeNCSIEnabled = TPCIeNCSIEnabled

NCSICapabilities.interface = mdb.register_interface('bmc.kepler.Systems.NCSICapabilities', {
    PCIeNCSIEnabled = {'y', nil, true, nil},
    PCIeNCSISupported = {'b', nil, true, nil}
}, {}, {})

return NCSICapabilities
