-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Led = {}

---@class Led.DefaultLCSColor
---@field DefaultLCSColor integer
local TDefaultLCSColor = {}
TDefaultLCSColor.__index = TDefaultLCSColor
TDefaultLCSColor.group = {}

local function TDefaultLCSColor_from_obj(obj)
    return setmetatable(obj, TDefaultLCSColor)
end

function TDefaultLCSColor.new(DefaultLCSColor)
    return TDefaultLCSColor_from_obj({DefaultLCSColor = DefaultLCSColor})
end
---@param obj Led.DefaultLCSColor
function TDefaultLCSColor:init_from_obj(obj)
    self.DefaultLCSColor = obj.DefaultLCSColor
end

function TDefaultLCSColor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultLCSColor.group)
end

TDefaultLCSColor.from_obj = TDefaultLCSColor_from_obj

TDefaultLCSColor.proto_property = {'DefaultLCSColor'}

TDefaultLCSColor.default = {0}

TDefaultLCSColor.struct = {{name = 'DefaultLCSColor', is_array = false, struct = nil}}

function TDefaultLCSColor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultLCSColor', self.DefaultLCSColor, 'uint8', true, errs, need_convert)

    TDefaultLCSColor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultLCSColor.proto_property, errs, need_convert)
    return self
end

function TDefaultLCSColor:unpack(_)
    return self.DefaultLCSColor
end

Led.DefaultLCSColor = TDefaultLCSColor

---@class Led.DefaultOSColor
---@field DefaultOSColor integer
local TDefaultOSColor = {}
TDefaultOSColor.__index = TDefaultOSColor
TDefaultOSColor.group = {}

local function TDefaultOSColor_from_obj(obj)
    return setmetatable(obj, TDefaultOSColor)
end

function TDefaultOSColor.new(DefaultOSColor)
    return TDefaultOSColor_from_obj({DefaultOSColor = DefaultOSColor})
end
---@param obj Led.DefaultOSColor
function TDefaultOSColor:init_from_obj(obj)
    self.DefaultOSColor = obj.DefaultOSColor
end

function TDefaultOSColor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultOSColor.group)
end

TDefaultOSColor.from_obj = TDefaultOSColor_from_obj

TDefaultOSColor.proto_property = {'DefaultOSColor'}

TDefaultOSColor.default = {0}

TDefaultOSColor.struct = {{name = 'DefaultOSColor', is_array = false, struct = nil}}

function TDefaultOSColor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultOSColor', self.DefaultOSColor, 'uint8', true, errs, need_convert)

    TDefaultOSColor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultOSColor.proto_property, errs, need_convert)
    return self
end

function TDefaultOSColor:unpack(_)
    return self.DefaultOSColor
end

Led.DefaultOSColor = TDefaultOSColor

---@class Led.Mode
---@field Mode integer
local TMode = {}
TMode.__index = TMode
TMode.group = {}

local function TMode_from_obj(obj)
    return setmetatable(obj, TMode)
end

function TMode.new(Mode)
    return TMode_from_obj({Mode = Mode})
end
---@param obj Led.Mode
function TMode:init_from_obj(obj)
    self.Mode = obj.Mode
end

function TMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMode.group)
end

TMode.from_obj = TMode_from_obj

TMode.proto_property = {'Mode'}

TMode.default = {0}

TMode.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', true, errs, need_convert)

    TMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMode.proto_property, errs, need_convert)
    return self
end

function TMode:unpack(_)
    return self.Mode
end

Led.Mode = TMode

---@class Led.OverrideStateColor
---@field OverrideStateColor string
local TOverrideStateColor = {}
TOverrideStateColor.__index = TOverrideStateColor
TOverrideStateColor.group = {}

local function TOverrideStateColor_from_obj(obj)
    return setmetatable(obj, TOverrideStateColor)
end

function TOverrideStateColor.new(OverrideStateColor)
    return TOverrideStateColor_from_obj({OverrideStateColor = OverrideStateColor})
end
---@param obj Led.OverrideStateColor
function TOverrideStateColor:init_from_obj(obj)
    self.OverrideStateColor = obj.OverrideStateColor
end

function TOverrideStateColor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOverrideStateColor.group)
end

TOverrideStateColor.from_obj = TOverrideStateColor_from_obj

TOverrideStateColor.proto_property = {'OverrideStateColor'}

TOverrideStateColor.default = {''}

TOverrideStateColor.struct = {{name = 'OverrideStateColor', is_array = false, struct = nil}}

function TOverrideStateColor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OverrideStateColor', self.OverrideStateColor, 'string', true, errs, need_convert)

    TOverrideStateColor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOverrideStateColor.proto_property, errs, need_convert)
    return self
end

function TOverrideStateColor:unpack(_)
    return self.OverrideStateColor
end

Led.OverrideStateColor = TOverrideStateColor

---@class Led.LocalControlStateColor
---@field LocalControlStateColor string
local TLocalControlStateColor = {}
TLocalControlStateColor.__index = TLocalControlStateColor
TLocalControlStateColor.group = {}

local function TLocalControlStateColor_from_obj(obj)
    return setmetatable(obj, TLocalControlStateColor)
end

function TLocalControlStateColor.new(LocalControlStateColor)
    return TLocalControlStateColor_from_obj({LocalControlStateColor = LocalControlStateColor})
end
---@param obj Led.LocalControlStateColor
function TLocalControlStateColor:init_from_obj(obj)
    self.LocalControlStateColor = obj.LocalControlStateColor
end

function TLocalControlStateColor:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocalControlStateColor.group)
end

TLocalControlStateColor.from_obj = TLocalControlStateColor_from_obj

TLocalControlStateColor.proto_property = {'LocalControlStateColor'}

TLocalControlStateColor.default = {''}

TLocalControlStateColor.struct = {{name = 'LocalControlStateColor', is_array = false, struct = nil}}

function TLocalControlStateColor:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LocalControlStateColor', self.LocalControlStateColor, 'string', true, errs,
        need_convert)

    TLocalControlStateColor:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocalControlStateColor.proto_property, errs, need_convert)
    return self
end

function TLocalControlStateColor:unpack(_)
    return self.LocalControlStateColor
end

Led.LocalControlStateColor = TLocalControlStateColor

---@class Led.ColorCapabilities
---@field ColorCapabilities integer
local TColorCapabilities = {}
TColorCapabilities.__index = TColorCapabilities
TColorCapabilities.group = {}

local function TColorCapabilities_from_obj(obj)
    return setmetatable(obj, TColorCapabilities)
end

function TColorCapabilities.new(ColorCapabilities)
    return TColorCapabilities_from_obj({ColorCapabilities = ColorCapabilities})
end
---@param obj Led.ColorCapabilities
function TColorCapabilities:init_from_obj(obj)
    self.ColorCapabilities = obj.ColorCapabilities
end

function TColorCapabilities:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TColorCapabilities.group)
end

TColorCapabilities.from_obj = TColorCapabilities_from_obj

TColorCapabilities.proto_property = {'ColorCapabilities'}

TColorCapabilities.default = {0}

TColorCapabilities.struct = {{name = 'ColorCapabilities', is_array = false, struct = nil}}

function TColorCapabilities:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ColorCapabilities', self.ColorCapabilities, 'uint8', true, errs, need_convert)

    TColorCapabilities:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TColorCapabilities.proto_property, errs, need_convert)
    return self
end

function TColorCapabilities:unpack(_)
    return self.ColorCapabilities
end

Led.ColorCapabilities = TColorCapabilities

---@class Led.FruId
---@field FruId integer
local TFruId = {}
TFruId.__index = TFruId
TFruId.group = {}

local function TFruId_from_obj(obj)
    return setmetatable(obj, TFruId)
end

function TFruId.new(FruId)
    return TFruId_from_obj({FruId = FruId})
end
---@param obj Led.FruId
function TFruId:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TFruId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruId.group)
end

TFruId.from_obj = TFruId_from_obj

TFruId.proto_property = {'FruId'}

TFruId.default = {0}

TFruId.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TFruId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', true, errs, need_convert)

    TFruId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruId.proto_property, errs, need_convert)
    return self
end

function TFruId:unpack(_)
    return self.FruId
end

Led.FruId = TFruId

---@class Led.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Led.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Led.Id = TId

---@class Led.State
---@field State integer
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State})
end
---@param obj Led.State
function TState:init_from_obj(obj)
    self.State = obj.State
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {0}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

Led.State = TState

---@class Led.Capability
---@field Capability integer
local TCapability = {}
TCapability.__index = TCapability
TCapability.group = {}

local function TCapability_from_obj(obj)
    return setmetatable(obj, TCapability)
end

function TCapability.new(Capability)
    return TCapability_from_obj({Capability = Capability})
end
---@param obj Led.Capability
function TCapability:init_from_obj(obj)
    self.Capability = obj.Capability
end

function TCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapability.group)
end

TCapability.from_obj = TCapability_from_obj

TCapability.proto_property = {'Capability'}

TCapability.default = {0}

TCapability.struct = {{name = 'Capability', is_array = false, struct = nil}}

function TCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Capability', self.Capability, 'uint8', true, errs, need_convert)

    TCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapability.proto_property, errs, need_convert)
    return self
end

function TCapability:unpack(_)
    return self.Capability
end

Led.Capability = TCapability

---@class Led.OffDuration
---@field OffDuration integer
local TOffDuration = {}
TOffDuration.__index = TOffDuration
TOffDuration.group = {}

local function TOffDuration_from_obj(obj)
    return setmetatable(obj, TOffDuration)
end

function TOffDuration.new(OffDuration)
    return TOffDuration_from_obj({OffDuration = OffDuration or 0})
end
---@param obj Led.OffDuration
function TOffDuration:init_from_obj(obj)
    self.OffDuration = obj.OffDuration or 0
end

function TOffDuration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOffDuration.group)
end

TOffDuration.from_obj = TOffDuration_from_obj

TOffDuration.proto_property = {'OffDuration'}

TOffDuration.default = {0}

TOffDuration.struct = {{name = 'OffDuration', is_array = false, struct = nil}}

function TOffDuration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OffDuration', self.OffDuration, 'uint8', true, errs, need_convert)

    TOffDuration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOffDuration.proto_property, errs, need_convert)
    return self
end

function TOffDuration:unpack(_)
    return self.OffDuration
end

Led.OffDuration = TOffDuration

---@class Led.OnDuration
---@field OnDuration integer
local TOnDuration = {}
TOnDuration.__index = TOnDuration
TOnDuration.group = {}

local function TOnDuration_from_obj(obj)
    return setmetatable(obj, TOnDuration)
end

function TOnDuration.new(OnDuration)
    return TOnDuration_from_obj({OnDuration = OnDuration or 0})
end
---@param obj Led.OnDuration
function TOnDuration:init_from_obj(obj)
    self.OnDuration = obj.OnDuration or 0
end

function TOnDuration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOnDuration.group)
end

TOnDuration.from_obj = TOnDuration_from_obj

TOnDuration.proto_property = {'OnDuration'}

TOnDuration.default = {0}

TOnDuration.struct = {{name = 'OnDuration', is_array = false, struct = nil}}

function TOnDuration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OnDuration', self.OnDuration, 'uint8', true, errs, need_convert)

    TOnDuration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOnDuration.proto_property, errs, need_convert)
    return self
end

function TOnDuration:unpack(_)
    return self.OnDuration
end

Led.OnDuration = TOnDuration

---@class Led.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj Led.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

Led.Name = TName

---@class Led.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj Led.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

Led.SystemId = TSystemId

---@class Led.SetStateRsp
---@field State integer
---@field OnDuration integer
---@field OffDuration integer
local TSetStateRsp = {}
TSetStateRsp.__index = TSetStateRsp
TSetStateRsp.group = {}

local function TSetStateRsp_from_obj(obj)
    return setmetatable(obj, TSetStateRsp)
end

function TSetStateRsp.new(State, OnDuration, OffDuration)
    return TSetStateRsp_from_obj({State = State, OnDuration = OnDuration, OffDuration = OffDuration})
end
---@param obj Led.SetStateRsp
function TSetStateRsp:init_from_obj(obj)
    self.State = obj.State
    self.OnDuration = obj.OnDuration
    self.OffDuration = obj.OffDuration
end

function TSetStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStateRsp.group)
end

TSetStateRsp.from_obj = TSetStateRsp_from_obj

TSetStateRsp.proto_property = {'State', 'OnDuration', 'OffDuration'}

TSetStateRsp.default = {0, 0, 0}

TSetStateRsp.struct = {
    {name = 'State', is_array = false, struct = nil}, {name = 'OnDuration', is_array = false, struct = nil},
    {name = 'OffDuration', is_array = false, struct = nil}
}

function TSetStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OnDuration', self.OnDuration, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OffDuration', self.OffDuration, 'uint8', false, errs, need_convert)

    TSetStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetStateRsp:unpack(_)
    return self.State, self.OnDuration, self.OffDuration
end

Led.SetStateRsp = TSetStateRsp

---@class Led.SetStateReq
---@field State integer
---@field Interval integer
local TSetStateReq = {}
TSetStateReq.__index = TSetStateReq
TSetStateReq.group = {}

local function TSetStateReq_from_obj(obj)
    return setmetatable(obj, TSetStateReq)
end

function TSetStateReq.new(State, Interval)
    return TSetStateReq_from_obj({State = State, Interval = Interval})
end
---@param obj Led.SetStateReq
function TSetStateReq:init_from_obj(obj)
    self.State = obj.State
    self.Interval = obj.Interval
end

function TSetStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStateReq.group)
end

TSetStateReq.from_obj = TSetStateReq_from_obj

TSetStateReq.proto_property = {'State', 'Interval'}

TSetStateReq.default = {0, 0}

TSetStateReq.struct = {
    {name = 'State', is_array = false, struct = nil}, {name = 'Interval', is_array = false, struct = nil}
}

function TSetStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Interval', self.Interval, 'uint8', false, errs, need_convert)

    TSetStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStateReq.proto_property, errs, need_convert)
    return self
end

function TSetStateReq:unpack(_)
    return self.State, self.Interval
end

Led.SetStateReq = TSetStateReq

Led.interface = mdb.register_interface('bmc.kepler.Systems.Led', {
    SystemId = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    OnDuration = {'y', nil, true, 0},
    OffDuration = {'y', nil, true, 0},
    Capability = {'y', nil, true, nil},
    State = {'y', nil, false, nil},
    Id = {'y', nil, true, nil},
    FruId = {'y', nil, true, nil},
    ColorCapabilities = {'y', {}, true, nil},
    LocalControlStateColor = {'s', {}, true, nil},
    OverrideStateColor = {'s', {}, true, nil},
    Mode = {'y', {}, true, nil},
    DefaultOSColor = {'y', {}, true, nil},
    DefaultLCSColor = {'y', {}, true, nil}
}, {SetState = {'a{ss}yy', 'yyy', TSetStateReq, TSetStateRsp}}, {})

return Led
