-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Fan = {}

---@class Fan.SetFanPWMRsp
---@field Result integer
local TSetFanPWMRsp = {}
TSetFanPWMRsp.__index = TSetFanPWMRsp
TSetFanPWMRsp.group = {}

local function TSetFanPWMRsp_from_obj(obj)
    return setmetatable(obj, TSetFanPWMRsp)
end

function TSetFanPWMRsp.new(Result)
    return TSetFanPWMRsp_from_obj({Result = Result})
end
---@param obj Fan.SetFanPWMRsp
function TSetFanPWMRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetFanPWMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanPWMRsp.group)
end

TSetFanPWMRsp.from_obj = TSetFanPWMRsp_from_obj

TSetFanPWMRsp.proto_property = {'Result'}

TSetFanPWMRsp.default = {0}

TSetFanPWMRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetFanPWMRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'uint8', false, errs, need_convert)

    TSetFanPWMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanPWMRsp.proto_property, errs, need_convert)
    return self
end

function TSetFanPWMRsp:unpack(_)
    return self.Result
end

Fan.SetFanPWMRsp = TSetFanPWMRsp

---@class Fan.SetFanPWMReq
---@field PWM number
local TSetFanPWMReq = {}
TSetFanPWMReq.__index = TSetFanPWMReq
TSetFanPWMReq.group = {}

local function TSetFanPWMReq_from_obj(obj)
    return setmetatable(obj, TSetFanPWMReq)
end

function TSetFanPWMReq.new(PWM)
    return TSetFanPWMReq_from_obj({PWM = PWM})
end
---@param obj Fan.SetFanPWMReq
function TSetFanPWMReq:init_from_obj(obj)
    self.PWM = obj.PWM
end

function TSetFanPWMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFanPWMReq.group)
end

TSetFanPWMReq.from_obj = TSetFanPWMReq_from_obj

TSetFanPWMReq.proto_property = {'PWM'}

TSetFanPWMReq.default = {0}

TSetFanPWMReq.struct = {{name = 'PWM', is_array = false, struct = nil}}

function TSetFanPWMReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PWM', self.PWM, 'double', false, errs, need_convert)

    TSetFanPWMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFanPWMReq.proto_property, errs, need_convert)
    return self
end

function TSetFanPWMReq:unpack(_)
    return self.PWM
end

Fan.SetFanPWMReq = TSetFanPWMReq

Fan.interface = mdb.register_interface('bmc.kepler.Systems.Fan', {
    FanId = {'q', nil, true, nil},
    Slot = {'y', nil, true, nil},
    Type = {'y', nil, true, nil},
    Model = {'s', nil, true, nil},
    Coefficient = {'y', nil, true, nil},
    FanHealth = {'y', nil, true, nil},
    FanEntity = {'s', nil, true, nil},
    FrontPresence = {'y', nil, false, nil},
    RearPresence = {'y', nil, false, nil},
    FrontSpeed = {'q', {['emitsChangedSignal'] = 'true'}, false, nil},
    RearSpeed = {'q', {['emitsChangedSignal'] = 'true'}, false, nil},
    FrontStatus = {'y', nil, true, nil},
    RearStatus = {'y', nil, true, nil},
    FrontRPM = {'q', nil, true, nil},
    RearRPM = {'q', nil, true, nil},
    HardwarePWM = {'d', nil, false, nil},
    PWMPercentage = {'u', nil, true, nil},
    ExpectedPWM = {'d', nil, false, nil},
    FanAlarmLed = {'y', nil, true, nil},
    BOM = {'s', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    MaxSupportedPWM = {'u', nil, true, nil},
    IdentifySpeedLevel = {'y', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    FrontMaxSpeed = {'u', nil, true, nil},
    RearMaxSpeed = {'u', nil, true, nil},
    IsTwins = {'b', nil, true, nil},
    Position = {'s', nil, true, nil},
    SpeedStable = {'b', nil, true, nil},
    FunctionDesc = {'s', nil, true, nil},
    DeviceName = {'s', nil, true, nil}
}, {SetFanPWM = {'a{ss}d', 'y', TSetFanPWMReq, TSetFanPWMRsp}}, {})

return Fan
