-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Dimension = {}

---@class Dimension.HeightU
---@field HeightU number
local THeightU = {}
THeightU.__index = THeightU
THeightU.group = {}

local function THeightU_from_obj(obj)
    return setmetatable(obj, THeightU)
end

function THeightU.new(HeightU)
    return THeightU_from_obj({HeightU = HeightU})
end
---@param obj Dimension.HeightU
function THeightU:init_from_obj(obj)
    self.HeightU = obj.HeightU
end

function THeightU:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THeightU.group)
end

THeightU.from_obj = THeightU_from_obj

THeightU.proto_property = {'HeightU'}

THeightU.default = {0}

THeightU.struct = {{name = 'HeightU', is_array = false, struct = nil}}

function THeightU:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HeightU', self.HeightU, 'double', true, errs, need_convert)

    THeightU:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THeightU.proto_property, errs, need_convert)
    return self
end

function THeightU:unpack(_)
    return self.HeightU
end

Dimension.HeightU = THeightU

Dimension.interface = mdb.register_interface('bmc.kepler.Chassis.Dimension', {HeightU = {'d', nil, true, nil}}, {}, {})

return Dimension
