-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Connector = {}

---@class Connector.ReloadRsp
local TReloadRsp = {}
TReloadRsp.__index = TReloadRsp
TReloadRsp.group = {}

local function TReloadRsp_from_obj(obj)
    return setmetatable(obj, TReloadRsp)
end

function TReloadRsp.new()
    return TReloadRsp_from_obj({})
end
---@param obj Connector.ReloadRsp
function TReloadRsp:init_from_obj(obj)

end

function TReloadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReloadRsp.group)
end

TReloadRsp.from_obj = TReloadRsp_from_obj

TReloadRsp.proto_property = {}

TReloadRsp.default = {}

TReloadRsp.struct = {}

function TReloadRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TReloadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReloadRsp.proto_property, errs, need_convert)
    return self
end

function TReloadRsp:unpack(_)
end

Connector.ReloadRsp = TReloadRsp

---@class Connector.ReloadReq
---@field Bom string
---@field Id string
---@field AuxId string
---@field IdentifyMode integer
local TReloadReq = {}
TReloadReq.__index = TReloadReq
TReloadReq.group = {}

local function TReloadReq_from_obj(obj)
    return setmetatable(obj, TReloadReq)
end

function TReloadReq.new(Bom, Id, AuxId, IdentifyMode)
    return TReloadReq_from_obj({Bom = Bom, Id = Id, AuxId = AuxId, IdentifyMode = IdentifyMode})
end
---@param obj Connector.ReloadReq
function TReloadReq:init_from_obj(obj)
    self.Bom = obj.Bom
    self.Id = obj.Id
    self.AuxId = obj.AuxId
    self.IdentifyMode = obj.IdentifyMode
end

function TReloadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReloadReq.group)
end

TReloadReq.from_obj = TReloadReq_from_obj

TReloadReq.proto_property = {'Bom', 'Id', 'AuxId', 'IdentifyMode'}

TReloadReq.default = {'', '', '', 0}

TReloadReq.struct = {
    {name = 'Bom', is_array = false, struct = nil}, {name = 'Id', is_array = false, struct = nil},
    {name = 'AuxId', is_array = false, struct = nil}, {name = 'IdentifyMode', is_array = false, struct = nil}
}

function TReloadReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bom', self.Bom, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'AuxId', self.AuxId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'IdentifyMode', self.IdentifyMode, 'uint8', false, errs, need_convert)

    TReloadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReloadReq.proto_property, errs, need_convert)
    return self
end

function TReloadReq:unpack(_)
    return self.Bom, self.Id, self.AuxId, self.IdentifyMode
end

Connector.ReloadReq = TReloadReq

Connector.interface = mdb.register_interface('bmc.kepler.Connector', {
    Bom = {'s', nil, true, nil},
    Slot = {'y', nil, false, nil},
    GroupId = {'u', nil, true, nil},
    GroupPosition = {'s', nil, true, nil},
    Presence = {'y', nil, false, nil},
    Id = {'s', nil, false, nil},
    AuxId = {'s', nil, false, nil},
    Buses = {'as', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    ManagerId = {'s', nil, true, nil},
    SilkText = {'s', nil, true, nil},
    Type = {'s', nil, true, nil},
    IdentifyMode = {'y', nil, true, nil},
    ChassisId = {'s', nil, true, nil},
    LoadStatus = {'y', nil, true, 255}
}, {Reload = {'a{ss}sssy', '', TReloadReq, TReloadRsp}}, {})

return Connector
