-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ChassisCapabilities = {}

---@class ChassisCapabilities.BridgeDeviceAddress
---@field BridgeDeviceAddress integer
local TBridgeDeviceAddress = {}
TBridgeDeviceAddress.__index = TBridgeDeviceAddress
TBridgeDeviceAddress.group = {}

local function TBridgeDeviceAddress_from_obj(obj)
    return setmetatable(obj, TBridgeDeviceAddress)
end

function TBridgeDeviceAddress.new(BridgeDeviceAddress)
    return TBridgeDeviceAddress_from_obj({BridgeDeviceAddress = BridgeDeviceAddress or 32})
end
---@param obj ChassisCapabilities.BridgeDeviceAddress
function TBridgeDeviceAddress:init_from_obj(obj)
    self.BridgeDeviceAddress = obj.BridgeDeviceAddress or 32
end

function TBridgeDeviceAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBridgeDeviceAddress.group)
end

TBridgeDeviceAddress.from_obj = TBridgeDeviceAddress_from_obj

TBridgeDeviceAddress.proto_property = {'BridgeDeviceAddress'}

TBridgeDeviceAddress.default = {0}

TBridgeDeviceAddress.struct = {{name = 'BridgeDeviceAddress', is_array = false, struct = nil}}

function TBridgeDeviceAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BridgeDeviceAddress', self.BridgeDeviceAddress, 'uint8', true, errs, need_convert)

    TBridgeDeviceAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBridgeDeviceAddress.proto_property, errs, need_convert)
    return self
end

function TBridgeDeviceAddress:unpack(_)
    return self.BridgeDeviceAddress
end

ChassisCapabilities.BridgeDeviceAddress = TBridgeDeviceAddress

---@class ChassisCapabilities.SMDeviceAddress
---@field SMDeviceAddress integer
local TSMDeviceAddress = {}
TSMDeviceAddress.__index = TSMDeviceAddress
TSMDeviceAddress.group = {}

local function TSMDeviceAddress_from_obj(obj)
    return setmetatable(obj, TSMDeviceAddress)
end

function TSMDeviceAddress.new(SMDeviceAddress)
    return TSMDeviceAddress_from_obj({SMDeviceAddress = SMDeviceAddress or 32})
end
---@param obj ChassisCapabilities.SMDeviceAddress
function TSMDeviceAddress:init_from_obj(obj)
    self.SMDeviceAddress = obj.SMDeviceAddress or 32
end

function TSMDeviceAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSMDeviceAddress.group)
end

TSMDeviceAddress.from_obj = TSMDeviceAddress_from_obj

TSMDeviceAddress.proto_property = {'SMDeviceAddress'}

TSMDeviceAddress.default = {0}

TSMDeviceAddress.struct = {{name = 'SMDeviceAddress', is_array = false, struct = nil}}

function TSMDeviceAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SMDeviceAddress', self.SMDeviceAddress, 'uint8', true, errs, need_convert)

    TSMDeviceAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSMDeviceAddress.proto_property, errs, need_convert)
    return self
end

function TSMDeviceAddress:unpack(_)
    return self.SMDeviceAddress
end

ChassisCapabilities.SMDeviceAddress = TSMDeviceAddress

---@class ChassisCapabilities.SELDeviceAddress
---@field SELDeviceAddress integer
local TSELDeviceAddress = {}
TSELDeviceAddress.__index = TSELDeviceAddress
TSELDeviceAddress.group = {}

local function TSELDeviceAddress_from_obj(obj)
    return setmetatable(obj, TSELDeviceAddress)
end

function TSELDeviceAddress.new(SELDeviceAddress)
    return TSELDeviceAddress_from_obj({SELDeviceAddress = SELDeviceAddress or 32})
end
---@param obj ChassisCapabilities.SELDeviceAddress
function TSELDeviceAddress:init_from_obj(obj)
    self.SELDeviceAddress = obj.SELDeviceAddress or 32
end

function TSELDeviceAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSELDeviceAddress.group)
end

TSELDeviceAddress.from_obj = TSELDeviceAddress_from_obj

TSELDeviceAddress.proto_property = {'SELDeviceAddress'}

TSELDeviceAddress.default = {0}

TSELDeviceAddress.struct = {{name = 'SELDeviceAddress', is_array = false, struct = nil}}

function TSELDeviceAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SELDeviceAddress', self.SELDeviceAddress, 'uint8', true, errs, need_convert)

    TSELDeviceAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSELDeviceAddress.proto_property, errs, need_convert)
    return self
end

function TSELDeviceAddress:unpack(_)
    return self.SELDeviceAddress
end

ChassisCapabilities.SELDeviceAddress = TSELDeviceAddress

---@class ChassisCapabilities.SDRDeviceAddress
---@field SDRDeviceAddress integer
local TSDRDeviceAddress = {}
TSDRDeviceAddress.__index = TSDRDeviceAddress
TSDRDeviceAddress.group = {}

local function TSDRDeviceAddress_from_obj(obj)
    return setmetatable(obj, TSDRDeviceAddress)
end

function TSDRDeviceAddress.new(SDRDeviceAddress)
    return TSDRDeviceAddress_from_obj({SDRDeviceAddress = SDRDeviceAddress or 32})
end
---@param obj ChassisCapabilities.SDRDeviceAddress
function TSDRDeviceAddress:init_from_obj(obj)
    self.SDRDeviceAddress = obj.SDRDeviceAddress or 32
end

function TSDRDeviceAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSDRDeviceAddress.group)
end

TSDRDeviceAddress.from_obj = TSDRDeviceAddress_from_obj

TSDRDeviceAddress.proto_property = {'SDRDeviceAddress'}

TSDRDeviceAddress.default = {0}

TSDRDeviceAddress.struct = {{name = 'SDRDeviceAddress', is_array = false, struct = nil}}

function TSDRDeviceAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SDRDeviceAddress', self.SDRDeviceAddress, 'uint8', true, errs, need_convert)

    TSDRDeviceAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSDRDeviceAddress.proto_property, errs, need_convert)
    return self
end

function TSDRDeviceAddress:unpack(_)
    return self.SDRDeviceAddress
end

ChassisCapabilities.SDRDeviceAddress = TSDRDeviceAddress

---@class ChassisCapabilities.FRUDeviceAddress
---@field FRUDeviceAddress integer
local TFRUDeviceAddress = {}
TFRUDeviceAddress.__index = TFRUDeviceAddress
TFRUDeviceAddress.group = {}

local function TFRUDeviceAddress_from_obj(obj)
    return setmetatable(obj, TFRUDeviceAddress)
end

function TFRUDeviceAddress.new(FRUDeviceAddress)
    return TFRUDeviceAddress_from_obj({FRUDeviceAddress = FRUDeviceAddress or 32})
end
---@param obj ChassisCapabilities.FRUDeviceAddress
function TFRUDeviceAddress:init_from_obj(obj)
    self.FRUDeviceAddress = obj.FRUDeviceAddress or 32
end

function TFRUDeviceAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFRUDeviceAddress.group)
end

TFRUDeviceAddress.from_obj = TFRUDeviceAddress_from_obj

TFRUDeviceAddress.proto_property = {'FRUDeviceAddress'}

TFRUDeviceAddress.default = {0}

TFRUDeviceAddress.struct = {{name = 'FRUDeviceAddress', is_array = false, struct = nil}}

function TFRUDeviceAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FRUDeviceAddress', self.FRUDeviceAddress, 'uint8', true, errs, need_convert)

    TFRUDeviceAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFRUDeviceAddress.proto_property, errs, need_convert)
    return self
end

function TFRUDeviceAddress:unpack(_)
    return self.FRUDeviceAddress
end

ChassisCapabilities.FRUDeviceAddress = TFRUDeviceAddress

---@class ChassisCapabilities.CapabilitiesFlags
---@field CapabilitiesFlags integer
local TCapabilitiesFlags = {}
TCapabilitiesFlags.__index = TCapabilitiesFlags
TCapabilitiesFlags.group = {}

local function TCapabilitiesFlags_from_obj(obj)
    return setmetatable(obj, TCapabilitiesFlags)
end

function TCapabilitiesFlags.new(CapabilitiesFlags)
    return TCapabilitiesFlags_from_obj({CapabilitiesFlags = CapabilitiesFlags})
end
---@param obj ChassisCapabilities.CapabilitiesFlags
function TCapabilitiesFlags:init_from_obj(obj)
    self.CapabilitiesFlags = obj.CapabilitiesFlags
end

function TCapabilitiesFlags:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapabilitiesFlags.group)
end

TCapabilitiesFlags.from_obj = TCapabilitiesFlags_from_obj

TCapabilitiesFlags.proto_property = {'CapabilitiesFlags'}

TCapabilitiesFlags.default = {0}

TCapabilitiesFlags.struct = {{name = 'CapabilitiesFlags', is_array = false, struct = nil}}

function TCapabilitiesFlags:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapabilitiesFlags', self.CapabilitiesFlags, 'uint8', true, errs, need_convert)

    TCapabilitiesFlags:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapabilitiesFlags.proto_property, errs, need_convert)
    return self
end

function TCapabilitiesFlags:unpack(_)
    return self.CapabilitiesFlags
end

ChassisCapabilities.CapabilitiesFlags = TCapabilitiesFlags

ChassisCapabilities.interface = mdb.register_interface('bmc.kepler.Chassis.ChassisCapabilities', {
    CapabilitiesFlags = {'y', {'EMIT_CHANGE'}, true, nil},
    FRUDeviceAddress = {'y', {'EMIT_CHANGE'}, true, 32},
    SDRDeviceAddress = {'y', {'EMIT_CHANGE'}, true, 32},
    SELDeviceAddress = {'y', {'EMIT_CHANGE'}, true, 32},
    SMDeviceAddress = {'y', {'EMIT_CHANGE'}, true, 32},
    BridgeDeviceAddress = {'y', {'EMIT_CHANGE'}, true, 32}
}, {}, {})

return ChassisCapabilities
