--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSuperPodSize = {}

---@class ChassisIpmiCmds.SetSuperPodSizeReq
---@field ManufactureId integer
---@field Reserved integer
---@field Data integer[]
local TSetSuperPodSizeReq = {}
TSetSuperPodSizeReq.__index = TSetSuperPodSizeReq
TSetSuperPodSizeReq.group = {}

local function TSetSuperPodSizeReq_from_obj(obj)
    return setmetatable(obj, TSetSuperPodSizeReq)
end

function TSetSuperPodSizeReq.new(ManufactureId, Reserved, Data)
    return TSetSuperPodSizeReq_from_obj({ManufactureId = ManufactureId, Reserved = Reserved, Data = Data})
end
---@param obj ChassisIpmiCmds.SetSuperPodSizeReq
function TSetSuperPodSizeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TSetSuperPodSizeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodSizeReq.group)
end

TSetSuperPodSizeReq.from_obj = TSetSuperPodSizeReq_from_obj

TSetSuperPodSizeReq.proto_property = {'ManufactureId', 'Reserved', 'Data'}

TSetSuperPodSizeReq.default = {0, 0, {}}

TSetSuperPodSizeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = true, struct = nil}
}

function TSetSuperPodSizeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    if self.Data ~= nil then
        validate.lens(prefix .. 'Data', self.Data, 2, 2, errs, need_convert)
    end

    TSetSuperPodSizeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodSizeReq.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodSizeReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.Data
end

SetSuperPodSize.SetSuperPodSizeReq = TSetSuperPodSizeReq

---@class ChassisIpmiCmds.SetSuperPodSizeRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSuperPodSizeRsp = {}
TSetSuperPodSizeRsp.__index = TSetSuperPodSizeRsp
TSetSuperPodSizeRsp.group = {}

local function TSetSuperPodSizeRsp_from_obj(obj)
    return setmetatable(obj, TSetSuperPodSizeRsp)
end

function TSetSuperPodSizeRsp.new(CompletionCode, ManufactureId)
    return TSetSuperPodSizeRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.SetSuperPodSizeRsp
function TSetSuperPodSizeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSuperPodSizeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodSizeRsp.group)
end

TSetSuperPodSizeRsp.from_obj = TSetSuperPodSizeRsp_from_obj

TSetSuperPodSizeRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSuperPodSizeRsp.default = {0, 0}

TSetSuperPodSizeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSuperPodSizeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSuperPodSizeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodSizeRsp.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodSizeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSuperPodSize.SetSuperPodSizeRsp = TSetSuperPodSizeRsp

return SetSuperPodSize
