--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSuperPodLabelInfo = {}

---@class ChassisIpmiCmds.SetSuperPodLabelInfoReq
---@field ManufactureId integer
---@field Reserved integer
---@field Data integer[]
local TSetSuperPodLabelInfoReq = {}
TSetSuperPodLabelInfoReq.__index = TSetSuperPodLabelInfoReq
TSetSuperPodLabelInfoReq.group = {}

local function TSetSuperPodLabelInfoReq_from_obj(obj)
    return setmetatable(obj, TSetSuperPodLabelInfoReq)
end

function TSetSuperPodLabelInfoReq.new(ManufactureId, Reserved, Data)
    return TSetSuperPodLabelInfoReq_from_obj({ManufactureId = ManufactureId, Reserved = Reserved, Data = Data})
end
---@param obj ChassisIpmiCmds.SetSuperPodLabelInfoReq
function TSetSuperPodLabelInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TSetSuperPodLabelInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodLabelInfoReq.group)
end

TSetSuperPodLabelInfoReq.from_obj = TSetSuperPodLabelInfoReq_from_obj

TSetSuperPodLabelInfoReq.proto_property = {'ManufactureId', 'Reserved', 'Data'}

TSetSuperPodLabelInfoReq.default = {0, 0, {}}

TSetSuperPodLabelInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = true, struct = nil}
}

function TSetSuperPodLabelInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    if self.Data ~= nil then
        validate.lens(prefix .. 'Data', self.Data, 8, 8, errs, need_convert)
    end

    TSetSuperPodLabelInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodLabelInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodLabelInfoReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.Data
end

SetSuperPodLabelInfo.SetSuperPodLabelInfoReq = TSetSuperPodLabelInfoReq

---@class ChassisIpmiCmds.SetSuperPodLabelInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSuperPodLabelInfoRsp = {}
TSetSuperPodLabelInfoRsp.__index = TSetSuperPodLabelInfoRsp
TSetSuperPodLabelInfoRsp.group = {}

local function TSetSuperPodLabelInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetSuperPodLabelInfoRsp)
end

function TSetSuperPodLabelInfoRsp.new(CompletionCode, ManufactureId)
    return TSetSuperPodLabelInfoRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.SetSuperPodLabelInfoRsp
function TSetSuperPodLabelInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSuperPodLabelInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodLabelInfoRsp.group)
end

TSetSuperPodLabelInfoRsp.from_obj = TSetSuperPodLabelInfoRsp_from_obj

TSetSuperPodLabelInfoRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSuperPodLabelInfoRsp.default = {0, 0}

TSetSuperPodLabelInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSuperPodLabelInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSuperPodLabelInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodLabelInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodLabelInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSuperPodLabelInfo.SetSuperPodLabelInfoRsp = TSetSuperPodLabelInfoRsp

return SetSuperPodLabelInfo
