--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSuperPodEnabled = {}

---@class ChassisIpmiCmds.SetSuperPodEnabledReq
---@field ManufactureId integer
---@field Reserved integer
---@field Data integer[]
local TSetSuperPodEnabledReq = {}
TSetSuperPodEnabledReq.__index = TSetSuperPodEnabledReq
TSetSuperPodEnabledReq.group = {}

local function TSetSuperPodEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetSuperPodEnabledReq)
end

function TSetSuperPodEnabledReq.new(ManufactureId, Reserved, Data)
    return TSetSuperPodEnabledReq_from_obj({ManufactureId = ManufactureId, Reserved = Reserved, Data = Data})
end
---@param obj ChassisIpmiCmds.SetSuperPodEnabledReq
function TSetSuperPodEnabledReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.Data = obj.Data
end

function TSetSuperPodEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodEnabledReq.group)
end

TSetSuperPodEnabledReq.from_obj = TSetSuperPodEnabledReq_from_obj

TSetSuperPodEnabledReq.proto_property = {'ManufactureId', 'Reserved', 'Data'}

TSetSuperPodEnabledReq.default = {0, 0, {}}

TSetSuperPodEnabledReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'Data', is_array = true, struct = nil}
}

function TSetSuperPodEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    if self.Data ~= nil then
        validate.lens(prefix .. 'Data', self.Data, 1, 1, errs, need_convert)
    end

    TSetSuperPodEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodEnabledReq.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodEnabledReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.Data
end

SetSuperPodEnabled.SetSuperPodEnabledReq = TSetSuperPodEnabledReq

---@class ChassisIpmiCmds.SetSuperPodEnabledRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSuperPodEnabledRsp = {}
TSetSuperPodEnabledRsp.__index = TSetSuperPodEnabledRsp
TSetSuperPodEnabledRsp.group = {}

local function TSetSuperPodEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetSuperPodEnabledRsp)
end

function TSetSuperPodEnabledRsp.new(CompletionCode, ManufactureId)
    return TSetSuperPodEnabledRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.SetSuperPodEnabledRsp
function TSetSuperPodEnabledRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSuperPodEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSuperPodEnabledRsp.group)
end

TSetSuperPodEnabledRsp.from_obj = TSetSuperPodEnabledRsp_from_obj

TSetSuperPodEnabledRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSuperPodEnabledRsp.default = {0, 0}

TSetSuperPodEnabledRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSuperPodEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSuperPodEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSuperPodEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TSetSuperPodEnabledRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSuperPodEnabled.SetSuperPodEnabledRsp = TSetSuperPodEnabledRsp

return SetSuperPodEnabled
