--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFruLedState = {}

---@class ChassisIpmiCmds.SetFruLedStateReq
---@field PicmgId integer
---@field FruId integer
---@field LedId integer
---@field LedFunc integer
---@field OnDuration integer
---@field Color integer
local TSetFruLedStateReq = {}
TSetFruLedStateReq.__index = TSetFruLedStateReq
TSetFruLedStateReq.group = {}

local function TSetFruLedStateReq_from_obj(obj)
    return setmetatable(obj, TSetFruLedStateReq)
end

function TSetFruLedStateReq.new(PicmgId, FruId, LedId, LedFunc, OnDuration, Color)
    return TSetFruLedStateReq_from_obj({
        PicmgId = PicmgId,
        FruId = FruId,
        LedId = LedId,
        LedFunc = LedFunc,
        OnDuration = OnDuration,
        Color = Color
    })
end
---@param obj ChassisIpmiCmds.SetFruLedStateReq
function TSetFruLedStateReq:init_from_obj(obj)
    self.PicmgId = obj.PicmgId
    self.FruId = obj.FruId
    self.LedId = obj.LedId
    self.LedFunc = obj.LedFunc
    self.OnDuration = obj.OnDuration
    self.Color = obj.Color
end

function TSetFruLedStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFruLedStateReq.group)
end

TSetFruLedStateReq.from_obj = TSetFruLedStateReq_from_obj

TSetFruLedStateReq.proto_property = {'PicmgId', 'FruId', 'LedId', 'LedFunc', 'OnDuration', 'Color'}

TSetFruLedStateReq.default = {0, 0, 0, 0, 0, 0}

TSetFruLedStateReq.struct = {
    {name = 'PicmgId', is_array = false, struct = nil}, {name = 'FruId', is_array = false, struct = nil},
    {name = 'LedId', is_array = false, struct = nil}, {name = 'LedFunc', is_array = false, struct = nil},
    {name = 'OnDuration', is_array = false, struct = nil}, {name = 'Color', is_array = false, struct = nil}
}

function TSetFruLedStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PicmgId', self.PicmgId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LedId', self.LedId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LedFunc', self.LedFunc, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'OnDuration', self.OnDuration, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Color', self.Color, 'uint8', false, errs, need_convert)

    TSetFruLedStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFruLedStateReq.proto_property, errs, need_convert)
    return self
end

function TSetFruLedStateReq:unpack(_)
    return self.PicmgId, self.FruId, self.LedId, self.LedFunc, self.OnDuration, self.Color
end

SetFruLedState.SetFruLedStateReq = TSetFruLedStateReq

---@class ChassisIpmiCmds.SetFruLedStateRsp
---@field CompletionCode integer
---@field PicmgId integer
local TSetFruLedStateRsp = {}
TSetFruLedStateRsp.__index = TSetFruLedStateRsp
TSetFruLedStateRsp.group = {}

local function TSetFruLedStateRsp_from_obj(obj)
    return setmetatable(obj, TSetFruLedStateRsp)
end

function TSetFruLedStateRsp.new(CompletionCode, PicmgId)
    return TSetFruLedStateRsp_from_obj({CompletionCode = CompletionCode, PicmgId = PicmgId})
end
---@param obj ChassisIpmiCmds.SetFruLedStateRsp
function TSetFruLedStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgId = obj.PicmgId
end

function TSetFruLedStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFruLedStateRsp.group)
end

TSetFruLedStateRsp.from_obj = TSetFruLedStateRsp_from_obj

TSetFruLedStateRsp.proto_property = {'CompletionCode', 'PicmgId'}

TSetFruLedStateRsp.default = {0, 0}

TSetFruLedStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'PicmgId', is_array = false, struct = nil}
}

function TSetFruLedStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgId', self.PicmgId, 'uint8', false, errs, need_convert)

    TSetFruLedStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFruLedStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetFruLedStateRsp:unpack(_)
    return self.CompletionCode, self.PicmgId
end

SetFruLedState.SetFruLedStateRsp = TSetFruLedStateRsp

return SetFruLedState
