--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetChassisCapabilities = {}

---@class ChassisIpmiCmds.SetChassisCapabilitiesReq
---@field CapabilitiesFlags integer
---@field FRUInfoAddr integer
---@field SDRAddr integer
---@field SELAddr integer
---@field SystemMgmtAddr integer
---@field BridgeAddr integer
local TSetChassisCapabilitiesReq = {}
TSetChassisCapabilitiesReq.__index = TSetChassisCapabilitiesReq
TSetChassisCapabilitiesReq.group = {}

local function TSetChassisCapabilitiesReq_from_obj(obj)
    return setmetatable(obj, TSetChassisCapabilitiesReq)
end

function TSetChassisCapabilitiesReq.new(CapabilitiesFlags, FRUInfoAddr, SDRAddr, SELAddr, SystemMgmtAddr, BridgeAddr)
    return TSetChassisCapabilitiesReq_from_obj({
        CapabilitiesFlags = CapabilitiesFlags,
        FRUInfoAddr = FRUInfoAddr,
        SDRAddr = SDRAddr,
        SELAddr = SELAddr,
        SystemMgmtAddr = SystemMgmtAddr,
        BridgeAddr = BridgeAddr
    })
end
---@param obj ChassisIpmiCmds.SetChassisCapabilitiesReq
function TSetChassisCapabilitiesReq:init_from_obj(obj)
    self.CapabilitiesFlags = obj.CapabilitiesFlags
    self.FRUInfoAddr = obj.FRUInfoAddr
    self.SDRAddr = obj.SDRAddr
    self.SELAddr = obj.SELAddr
    self.SystemMgmtAddr = obj.SystemMgmtAddr
    self.BridgeAddr = obj.BridgeAddr
end

function TSetChassisCapabilitiesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChassisCapabilitiesReq.group)
end

TSetChassisCapabilitiesReq.from_obj = TSetChassisCapabilitiesReq_from_obj

TSetChassisCapabilitiesReq.proto_property = {
    'CapabilitiesFlags', 'FRUInfoAddr', 'SDRAddr', 'SELAddr', 'SystemMgmtAddr', 'BridgeAddr'
}

TSetChassisCapabilitiesReq.default = {0, 0, 0, 0, 0, 0}

TSetChassisCapabilitiesReq.struct = {
    {name = 'CapabilitiesFlags', is_array = false, struct = nil},
    {name = 'FRUInfoAddr', is_array = false, struct = nil}, {name = 'SDRAddr', is_array = false, struct = nil},
    {name = 'SELAddr', is_array = false, struct = nil}, {name = 'SystemMgmtAddr', is_array = false, struct = nil},
    {name = 'BridgeAddr', is_array = false, struct = nil}
}

function TSetChassisCapabilitiesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapabilitiesFlags', self.CapabilitiesFlags, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FRUInfoAddr', self.FRUInfoAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SDRAddr', self.SDRAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SELAddr', self.SELAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemMgmtAddr', self.SystemMgmtAddr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BridgeAddr', self.BridgeAddr, 'uint8', false, errs, need_convert)

    TSetChassisCapabilitiesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChassisCapabilitiesReq.proto_property, errs, need_convert)
    return self
end

function TSetChassisCapabilitiesReq:unpack(_)
    return self.CapabilitiesFlags, self.FRUInfoAddr, self.SDRAddr, self.SELAddr, self.SystemMgmtAddr, self.BridgeAddr
end

SetChassisCapabilities.SetChassisCapabilitiesReq = TSetChassisCapabilitiesReq

---@class ChassisIpmiCmds.SetChassisCapabilitiesRsp
---@field CompletionCode integer
local TSetChassisCapabilitiesRsp = {}
TSetChassisCapabilitiesRsp.__index = TSetChassisCapabilitiesRsp
TSetChassisCapabilitiesRsp.group = {}

local function TSetChassisCapabilitiesRsp_from_obj(obj)
    return setmetatable(obj, TSetChassisCapabilitiesRsp)
end

function TSetChassisCapabilitiesRsp.new(CompletionCode)
    return TSetChassisCapabilitiesRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj ChassisIpmiCmds.SetChassisCapabilitiesRsp
function TSetChassisCapabilitiesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetChassisCapabilitiesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChassisCapabilitiesRsp.group)
end

TSetChassisCapabilitiesRsp.from_obj = TSetChassisCapabilitiesRsp_from_obj

TSetChassisCapabilitiesRsp.proto_property = {'CompletionCode'}

TSetChassisCapabilitiesRsp.default = {0}

TSetChassisCapabilitiesRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetChassisCapabilitiesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetChassisCapabilitiesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChassisCapabilitiesRsp.proto_property, errs, need_convert)
    return self
end

function TSetChassisCapabilitiesRsp:unpack(_)
    return self.CompletionCode
end

SetChassisCapabilities.SetChassisCapabilitiesRsp = TSetChassisCapabilitiesRsp

return SetChassisCapabilities
