--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSuperPodEnabled = {}

---@class ChassisIpmiCmds.GetSuperPodEnabledReq
---@field ManufactureId integer
local TGetSuperPodEnabledReq = {}
TGetSuperPodEnabledReq.__index = TGetSuperPodEnabledReq
TGetSuperPodEnabledReq.group = {}

local function TGetSuperPodEnabledReq_from_obj(obj)
    return setmetatable(obj, TGetSuperPodEnabledReq)
end

function TGetSuperPodEnabledReq.new(ManufactureId)
    return TGetSuperPodEnabledReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj ChassisIpmiCmds.GetSuperPodEnabledReq
function TGetSuperPodEnabledReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetSuperPodEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSuperPodEnabledReq.group)
end

TGetSuperPodEnabledReq.from_obj = TGetSuperPodEnabledReq_from_obj

TGetSuperPodEnabledReq.proto_property = {'ManufactureId'}

TGetSuperPodEnabledReq.default = {0}

TGetSuperPodEnabledReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetSuperPodEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetSuperPodEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSuperPodEnabledReq.proto_property, errs, need_convert)
    return self
end

function TGetSuperPodEnabledReq:unpack(_)
    return self.ManufactureId
end

GetSuperPodEnabled.GetSuperPodEnabledReq = TGetSuperPodEnabledReq

---@class ChassisIpmiCmds.GetSuperPodEnabledRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndFlag integer
---@field Data integer[]
local TGetSuperPodEnabledRsp = {}
TGetSuperPodEnabledRsp.__index = TGetSuperPodEnabledRsp
TGetSuperPodEnabledRsp.group = {}

local function TGetSuperPodEnabledRsp_from_obj(obj)
    return setmetatable(obj, TGetSuperPodEnabledRsp)
end

function TGetSuperPodEnabledRsp.new(CompletionCode, ManufactureId, EndFlag, Data)
    return TGetSuperPodEnabledRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndFlag = EndFlag,
        Data = Data
    })
end
---@param obj ChassisIpmiCmds.GetSuperPodEnabledRsp
function TGetSuperPodEnabledRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndFlag = obj.EndFlag
    self.Data = obj.Data
end

function TGetSuperPodEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSuperPodEnabledRsp.group)
end

TGetSuperPodEnabledRsp.from_obj = TGetSuperPodEnabledRsp_from_obj

TGetSuperPodEnabledRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndFlag', 'Data'}

TGetSuperPodEnabledRsp.default = {0, 0, 0, {}}

TGetSuperPodEnabledRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndFlag', is_array = false, struct = nil}, {name = 'Data', is_array = true, struct = nil}
}

function TGetSuperPodEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndFlag', self.EndFlag, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    TGetSuperPodEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSuperPodEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TGetSuperPodEnabledRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndFlag, self.Data
end

GetSuperPodEnabled.GetSuperPodEnabledRsp = TGetSuperPodEnabledRsp

return GetSuperPodEnabled
