[TOC]

# CHASSIS 机框管理

## 1、功能简介

本组件主要包括7大功能特性：

| 序号 | 功能特性 | 功能描述 |
|------|----------|----------|
| 1 | **整机状态管理** | 包括开箱事件检测、UID按钮事件上报、统计设备数量及设备可插最大数量、整机状态统计 |
| 2 | **I2cLed灯控制** | 为装备测试提供手段控制I2cLed灯的状态 |
| 3 | **Led灯控制** | 包括控制UID灯的状态、基于当前告警控制健康灯颜色变化 |
| 4 | **Led数码管显示** | 基于当前告警，在数码管上显示相应错误码 |
| 5 | **度量数据采集** | 对外提供入风口和出风口温度数据 |
| 6 | **读取设备配置能力** | 当前仅支持读取PCIe标卡NCSI线缆是否在位、主板对PCIe标卡NCSI功能是否支持 |
| 7 | **超节点属性配置与获取** | superpodid、server index、npu 规模(superpod size)并通过CPLD传递给芯片 |

## 2、关键特性

### 2.1 整机状态管理

#### 2.1.1 开箱事件检测

`Chassis`自动检测并记录服务器机箱盖的开合状态，确保服务器物理安全。
系统通过硬件上报监控机箱盖状态，例测检查寄存器数据。当检测到开盖时，设置开箱标志并记录日志；当检测到关盖时，清除标志并记录操作。并且还支持断电记忆功能，重新上电后能检测断电期间是否有人开过机箱。

#### 2.1.2 UID按钮事件上报

UID按钮事件分为UID短按事件与UID长按事件。

UID短按会将UID灯的亮灭状态进行转换，长按复位BMC。

短按事件是基于属性监听的机制实现的，但是UID长按会导致BMC直接复位，所以不能通过属性监听的机制实现。

UID长按事件的检测时机是在BMC启动之后，会检查寄存器，如果存在长按事件则上报。

#### 2.1.3 统计设备数量及设备可插最大数量

统计方法如下：
| 组件名称 | 数量获取 |
|---------|---------|
| CPU | 遍历资源协作接口上所有CPU |
| Memory | 遍历资源协作接口上加载的内存对象 |
| PCIe | 遍历所有Connector对象，记录Type为PCIe的数量 |
| Disk | 1、获取真实的硬盘个数<br>2、获取硬盘背板上槽位数和<br>3、取1和2中最大值+SATADOM和M.2硬盘的个数 |
| Psu | 1、遍历所有connector对象，记录Type为Ps的数量<br>2、获取所有OnePower对象，记录数量<br>3、取其中最大值为最大数量 |
| Fan | 获取所有风扇对象数量 |
| SecurityModule | 默认为1 |

#### 2.1.4 整机状态统计

该接口会按顺序获取：
| 序号 | 获取项目 | 说明 |
|------|----------|------|
| 1 | 开机策略 | 获取系统开机策略信息 |
| 2 | 电源故障信息 | 获取电源故障相关信息 |
| 3 | uid状态 | 获取UID灯状态信息 |
| 4 | 风扇健康状态 | 获取风扇健康状态信息 |
| 5 | 硬盘健康状态 | 获取硬盘健康状态信息 |

## 3、对外接口

### 资源协作接口

#### `/bmc/kepler/Systems/{SystemId}/Leds/{Id}` - `.SetState`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Systems/{SystemId}/Leds/{Id}` | `bmc.kepler.Systems.Led` | `.SetState` | `a{ss}yy` | `yyy` | 设置LED灯状态 | 控制指定LED灯的状态 | Id需唯一且存在，状态值需在支持范围 | 不涉及 | 同一LED同一时刻仅一种状态 | 需已初始化 | 不涉及 | Id在SystemId下唯一 | 不涉及 |

---

#### `/bmc/kepler/Chassis/{ChassisId}` - `.GetData`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Chassis/{ChassisId}` | `bmc.kepler.Metric` | `.GetData` | `a{ss}as` | `a(sas)` | 获取进风口出风口温度 | 获取机箱温度数据 | ChassisId需有效 | 不涉及 | 不涉及 | 需温度传感器正常 | 不涉及 | ChassisId唯一 | 不涉及 |

---

#### `/bmc/kepler/Chassis/{ChassisId}` - `.GetItems`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Chassis/{ChassisId}` | `bmc.kepler.Metric` | `.GetItems` | `a{ss}` | `sa(ss)a(ss)as` | 获取所度量数据项 | 获取机箱支持的度量项 | 返回项与硬件一致 | 不涉及 | 不涉及 | 依赖硬件 | 不涉及 | 每项名称唯一 | 不涉及 |

---

#### `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` - `.SetSuperPodId`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` | `bmc.kepler.Chassis.SuperPodLabel` | `.SetSuperPodId` | `a{ss}u` | `b` | 设置超节点id | 设置超节点ID | SuperPodId需唯一且为正整数 | 不涉及 | 不涉及 | 需先配置超节点 | 不涉及 | 集群内唯一 | 不涉及 |

---

#### `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` - `.SetServerIndex`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` | `bmc.kepler.Chassis.SuperPodLabel` | `.SetServerIndex` | `a{ss}q` | `b` | 设置超节点中服务器编号 | 设置超节点内服务器编号 | ServerIndex需唯一且为正整数 | 不涉及 | 不涉及 | 需先设置SuperPodId | 不涉及 | SuperPodId下唯一 | 不涉及 |

---

#### `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` - `.SetSuperPodSize`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` | `bmc.kepler.Chassis.SuperPodLabel` | `.SetSuperPodSize` | `a{ss}q` | `b` | 设置超节点规模 | 设置超节点规模 | SuperPodSize为正整数且不小于已配置服务器数 | 不涉及 | 不涉及 | 需先设置SuperPodId | 不涉及 | 不涉及 | 不涉及 |

---

#### `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` - `.RestoreDefaults`

| 接口路径 | 接口名称 | 方法名 | 输入参数 | 输出参数 | 说明 | 业务作用 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|----------|----------|--------|----------|----------|------|----------|------|------|----------|----------|----------|------------|------------|
| `/bmc/kepler/Chassis/{ChassisId}/SuperPodLabel` | `bmc.kepler.Chassis.SuperPodLabel` | `.RestoreDefaults` | `a{ss}` | `b` | 恢复超节点默认设置 | 恢复超节点配置为默认 | 恢复操作覆盖当前配置 | 不涉及 | 恢复与手动配置互斥 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |

### IPMI接口

| 命令路径 | 命令名称 | 功能说明 |
|----------|----------|----------|
| `/bmc/kepler/IpmiCmds/00/01/GetPowerCmd` | GetPowerCmd | 获取机框状态 |
| `/bmc/kepler/IpmiCmds/00/04/ChassisIdentify` | ChassisIdentify | 识别机框 |
| `/bmc/kepler/IpmiCmds/2C/06/GetLedColorCapabilities` | GetLedColorCapabilities | 获取机框颜色能力 |
| `/bmc/kepler/IpmiCmds/2C/07/SetFruLedState` | SetFruLedState | 设置LED状态 |
| `/bmc/kepler/IpmiCmds/30/92/GetDeviceCapabilities` | GetDeviceCapabilities | 获取设备能力 |
| `/bmc/kepler/IpmiCmds/30/92/SetDeviceCapabilities` | SetDeviceCapabilities | 设置设备能力 |
| `/bmc/kepler/IpmiCmds/30/94/GetChassisHeight` | GetChassisHeight | 获取机框高度 |
| `/bmc/kepler/IpmiCmds/30/94/GetShelfInfo` | GetShelfInfo | 获取机架信息 |
| `/bmc/kepler/IpmiCmds/30/94/GetSuperPodLabelInfo` | GetSuperPodLabelInfo | 获取超节点标签信息 |
| `/bmc/kepler/IpmiCmds/30/94/SetSuperPodLabelInfo` | SetSuperPodLabelInfo | 设置超节点标签信息 |
| `/bmc/kepler/IpmiCmds/30/94/SetSuperPodId` | SetSuperPodId | 设置超节点ID |
| `/bmc/kepler/IpmiCmds/30/94/SetServerIndex` | SetServerIndex | 设置服务器索引 |
| `/bmc/kepler/IpmiCmds/30/94/SetSuperPodSize` | SetSuperPodSize | 设置超节点规模 |
| `/bmc/kepler/IpmiCmds/30/94/SetSuperPodEnabled` | SetSuperPodEnabled | 设置超节点启用状态 |
| `/bmc/kepler/IpmiCmds/30/94/GetSuperPodEnabled` | GetSuperPodEnabled | 获取超节点启用状态 |

## 4、配置介绍

### 4.1 Led对象配置指导

| 属性名 | 类型 | 必填 | 示例值 | 描述 |
|--------|------|------|--------|------|
| Id | U8 | ✅ | 4 | LED唯一标识符 |
| SystemId | U8 | ✅ | 1 | 系统ID |
| Name | String | ✅ | "UIDLed" | LED名称 |
| CtrlValue | U8 | ❌ | - | 控制值，可引用Accessor |
| Capability | U8 | ❌ | 1 | LED能力 |
| Mode | U8 | ❌ | 0 | LED模式 |
| ColorCapabilities | U8 | ❌ | 2 | LED支持的颜色能力 |
| DefaultOSColor | U8 | ❌ | 1 | 默认超驰颜色 |
| DefaultLCSColor | U8 | ❌ | 1 | 默认本地控制颜色 |
| LCSColor | U8 | ❌ | 1 | 本地控制状态颜色 |
| LCSState | U8 | ❌ | 0 | 本地控制状态 |
| OSColor | U8 | ❌ | 1 | 超驰状态颜色 |
| OSState | U8 | ❌ | 0 | 超驰状态 |
| LampTestColor | U8 | ❌ | 1 | 灯测试颜色 |
| LampTestDuration | U8 | ❌ | 0 | 灯测试持续时间 |

**配置说明：**
- ✅ 表示必填属性，❌ 表示可选属性
- 颜色值说明：0=Reserved(保留), 1=BLUE(蓝色), 2=RED(红色), 3=GREEN(绿色), 4=AMBER(琥珀色), 5=ORANGE(橙色), 6=WHITE(白色)
- 示例可以参考vpd仓中配置
