-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local bios_enum = require 'domain.bios_firmware.defs'
local prop_def = require 'macros.property_def'
local upgrade_service = require 'service.upgrade_service'
local context = require 'mc.context'
local upgrade_service = require 'service.upgrade_service'
local bios_service = require 'service.bios_service'
local open_db = require 'bios.db'
local test_common = require 'test_common.utils'
local bus = test_common.dbus_launch('../.dbus', nil, true)

TestService= {}

local function construct_db()
    local ok, datas = pcall(require, 'bios.datas')
    if not ok then
        -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
        datas = nil
    end
    local db = open_db(':memory:', datas)
    return db
end

function TestService:test_check_soc_type()
    local upgrade_service_instance = upgrade_service.new(construct_db(), {})
    local c_get_spi_rate = upgrade_service_instance.get_spi_rate
    local c_get_package_snapshot = upgrade_service_instance.get_package_snapshot
    local bios_ser = bios_service.get_instance(bus, construct_db())

    upgrade_service_instance.get_spi_rate = function()
        return 1
    end
    upgrade_service_instance.get_package_snapshot = function()
        return {
            get_period = function()
                return bios_enum.PackagePeriod.Period2
            end
        }
    end
    local frequency_mhz, firmware_size, is_support = upgrade_service_instance:check_soc_type()
    lu.assertEquals(frequency_mhz, '')
    lu.assertEquals(firmware_size, prop_def.BIOS_FILE_LEN)
    lu.assertEquals(is_support, true)

    upgrade_service_instance.get_package_snapshot = function()
        return {
            get_period = function()
                return bios_enum.PackagePeriod.Period3
            end,
            get_system_id = function ()
                return 1
            end
        }
    end
    bios_ser:get_bios_id()
    bios_ser.get_prop = function()
        return 64
    end
    frequency_mhz, firmware_size, is_support = upgrade_service_instance:check_soc_type()
    lu.assertEquals(frequency_mhz, 'g_clk_mhz=1')
    lu.assertEquals(firmware_size, 64 * prop_def.BIOS_FILE_LEN_KUNPENGB)
    lu.assertEquals(is_support, true)

    upgrade_service_instance.get_spi_rate = c_get_spi_rate
    upgrade_service_instance.get_package_snapshot = c_get_package_snapshot
end