-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local lu = require 'luaunit'
local spi_flash_channel = require 'domain.bios_firmware.package.channel.spi_flash_channel'
local ipmb_channel = require 'domain.bios_firmware.package.channel.ipmb_channel'
local channel_selector = require 'domain.bios_firmware.package.channel.channel_selector'
local bios_enum = require 'domain.bios_firmware.defs'

TestChannel= {}

function TestChannel:test_ipmb_channel()
    local channel = ipmb_channel.new()
    lu.assertEquals(channel.channel_name, 'IpmbChannel')
    local ok = pcall(function()
        channel:upgrade()
    end)
    lu.assertEquals(ok, false)
end

function TestChannel:test_spi_channel()
    local channel = spi_flash_channel.new()
    lu.assertEquals(channel.channel_name, 'FlashChannel')
    local ok = pcall(function()
        channel:upgrade()
    end)
    lu.assertEquals(ok, false)
end

local function channel_select(mode, period, channel_name)
    local selector = channel_selector.new()
    local ctx = {
        UpgradeMode = mode,
        Period = period,
    }
    local channels = selector:select(ctx)
    for _, channel in pairs(channels) do
        lu.assertEquals(channel.channel_name, channel_name)
    end
end

function TestChannel:test_channel_selector()
    channel_select(bios_enum.UpgradeMode.Cold, bios_enum.PackagePeriod.Period2, 'FlashChannel')
    channel_select(bios_enum.UpgradeMode.Cold, bios_enum.PackagePeriod.Period3, 'FlashChannel')
    channel_select(bios_enum.UpgradeMode.Hot, bios_enum.PackagePeriod.Period2, 'FlashChannel')
    channel_select(bios_enum.UpgradeMode.Hot, bios_enum.PackagePeriod.Period3, 'IpmbChannel')
    channel_select(bios_enum.UpgradeMode.Force, bios_enum.PackagePeriod.Period2, 'FlashChannel')
    channel_select(bios_enum.UpgradeMode.Force, bios_enum.PackagePeriod.Period3, 'FlashChannel')
end