-- Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_enum = require 'bios.types.enums'
local smbios_service = require 'service.smbios_service'
local smbios_handler = require 'bios.smbios'
local mdb = require 'mc.mdb'
local lu = require 'luaunit'
local utils = require 'mc.utils'

local project_dir = os.getenv('PROJECT_DIR')

TestSmbiosService = {}

function TestSmbiosService:setupClass()
    self.smbios_service = smbios_service.new()
    self.smbios_service.smbios_object_collection[1] = {
        update_smbios_status = function()
        end,
        get_smbios_updated_flag = function()
        end
    }
    local smbios_handler_obj = smbios_handler.new(1, project_dir.. '/test/test_data/SMBIOS_CONF_BAK')
    self.smbios_service.smbios_handler_collection[1] = smbios_handler_obj

    self.mdb_firmware_obj = {
        ReleaseDate = ''
    }
    mdb.get_cached_object = function()
        return self.mdb_firmware_obj
    end
end

function TestSmbiosService:teardownClass()
    self.smbios_service.smbios_object_collection = {}
    self.smbios_service.smbios_handler_collection = {}
    utils.remove_file(project_dir.. '/test/test_data/SMBIOS_CONF_BAK')
end

function TestSmbiosService:test_update_smbios_status()
    self.smbios_service:update_smbios_status(bios_enum.SmbiosWriteStage.SMBIOS_WRITE_FINISH, 1)
    lu.assertEquals(self.mdb_firmware_obj.ReleaseDate, '')
end