-- Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local reset_lock = require 'infrastructure.reset_lock'
local signal = require 'interface.signal'
local client = require 'bios.client'

test_reset_lock = {}

function test_reset_lock:test_lock_internel()
    local reset_lock_instance = reset_lock.new()
    local GetSystemControlObjects = client.GetSystemControlObjects
    local GetFirmwareMatchRulesObjects = client.GetFirmwareMatchRulesObjects
    client.GetSystemControlObjects = function()
        return {}
    end
    client.GetFirmwareMatchRulesObjects = function ()
        return {}
    end
    local ok = reset_lock_instance:lock_internel('Lock')
    lu.assertEquals(ok, false)

    client.GetSystemControlObjects = function()
        local objs = {}
        local obj = {}
        obj.pcall = {}
        obj.pcall.SetResetLockStatus = function()
        end
        table.insert(objs, obj)
        return objs
    end

    ok = reset_lock_instance:lock_internel('Lock')
    lu.assertEquals(ok, false)

    client.GetSystemControlObjects = function()
        local objs = {}
        local obj = {}
        obj.pcall = {}
        obj.pcall.SetResetLockStatus = function()
            return true
        end
        table.insert(objs, obj)
        return objs
    end

    client.GetFirmwareMatchRulesObjects = function ()
        local objs = {}
        local obj = {}
        obj.pcall = {}
        obj.pcall.AddMatchRules = function()
        end
        obj.pcall.DeleteMatchRules = function()
        end
        table.insert(objs, obj)
        return objs
    end

    ok = reset_lock_instance:lock_internel('Lock')
    lu.assertEquals(ok, true)
    ok = reset_lock_instance:lock_internel('UnLock')
    lu.assertEquals(ok, true)

    client.GetSystemControlObjects = GetSystemControlObjects
    client.GetFirmwareMatchRulesObjects = GetFirmwareMatchRulesObjects
end

function test_reset_lock:test_lock_and_unlock()
    local reset_lock_instance = reset_lock.new()
    local lock_internel = reset_lock_instance.lock_internel
    reset_lock_instance.lock_internel = function()
        return true
    end

    local ok = pcall(function ()
        reset_lock_instance:lock(1)
    end)
    lu.assertEquals(ok, true)
    local count = reset_lock_instance:get_task_count()
    lu.assertEquals(count, 1)

    ok = pcall(function ()
        reset_lock_instance:lock(2)
    end)
    lu.assertEquals(ok, true)
    count = reset_lock_instance:get_task_count()
    lu.assertEquals(count, 2)

    ok = pcall(function ()
        reset_lock_instance:unlock(1)
    end)
    lu.assertEquals(ok, true)
    count = reset_lock_instance:get_task_count()
    lu.assertEquals(count, 1)

    ok = pcall(function ()
        signal.unlock_bmc(2)
    end)
    lu.assertEquals(ok, true)
    count = reset_lock_instance:get_task_count()
    lu.assertEquals(count, 0)

    reset_lock_instance.lock_internel = lock_internel
end