-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_factory = require 'factory.bios_factory'
local bios_service = require 'service.bios_service'
local ipmi = require 'ipmi'
local comp_code = ipmi.types.Cc
local lu = require 'luaunit'
local bs_util = require 'util.base_util'
local defs = require 'domain.alarm.defs'
local event = require 'infrastructure.event'
local client = require 'bios.client'

local test_common = require 'test_common.utils'
local bus = test_common.dbus_launch('../.dbus', nil, true)

local object_def = require 'macros.object_def'

TestReportAlarm = {}


local function construct_ctx()
    local ctx = {}
    ctx.get_initiator = function()
        return {}
    end

    return ctx
end

function TestReportAlarm:test_report_power_link_alarm()
    local ctx = construct_ctx()
    local req = {}
    req.ManufactureId = bios_service:get_manu_id()
    req.EventType = 0x80
    req.AlarmType = 0
    req.Info =  bs_util.struct_to_binary({
        CpuId = 1,
        TypeId = 1,
        DieId = 1,
        ChannelId = 1
    }, '<<CpuId, TypeId, DieId, ChannelId>>')
    bios_service:report_alarm(defs.DeviceId.PSU, req, ctx)
end

function TestReportAlarm:test_report_memory_link_alarm()
    local ctx = construct_ctx()
    local req = {}
    req.ManufactureId = bios_service:get_manu_id()
    req.EventType = 0x80
    req.AlarmType = 1
    req.Info = bs_util.struct_to_binary({
        CpuId = 1,
        ChannelId = 1,
        DIMMId = 1
    }, '<<CpuId, ChannelId, DIMMId>>')
    bios_service:report_alarm(defs.DeviceId.PSU, req, ctx)
end

function TestReportAlarm:test_report_vr_alarm()
    local ctx = construct_ctx()
    bios_service:set_cpu_die({
        IdRange = {0, 1, 2, 3},
        NameRange = {'NA', 'TA', 'NB', 'TB'}
    })

    local req = {}
    req.ManufactureId = bios_service:get_manu_id()
    req.EventType = 0x80
    req.AlarmType = 0

    req.Info = bs_util.struct_to_binary({
        CpuId = 1,
        TypeId = 1,
        DieId = 1
    }, '<<CpuId, TypeId, DieId>>')

    --bios_service:report_alarm(defs.DeviceId.VR, req, ctx)
    pcall(function()
        bios_service:report_alarm(defs.DeviceId.VR, req, ctx)
    end)

end

function TestReportAlarm:test_get_cpu_ids()
    local bios_db_obj = {}
    bios_db_obj.save = function() end
    bios_db_obj.OldSetupPassword = ''
    bios_db_obj.NewSetupPassword = ''
    bios_db_obj.UserOldSetupPassword = ''
    bios_db_obj.UserNewSetupPassword = ''
    local bios_ser = bios_service.get_instance(bus, bios_db_obj)
    local obj_service = {}
    obj_service.get_object_list = function(name, path, interface)
        local obj1 = {
            [object_def.CPU_PROPERTY_DEVICELOCATOR] = {
                value = function()
                    return "CPU0"
                end
            }
        }
        local obj2 = {
            [object_def.CPU_PROPERTY_DEVICELOCATOR] = {
                value = function()
                    return "CPU1"
                end
            }
        }
        local obj_list = {obj1, obj2, nil}
        return obj_list
    end
    bios_factory.register_bean('object_service', obj_service)
    bios_factory.register_bean('bios_ser', bios_ser)
    local c_get_service = bios_factory.get_service
    bios_factory.get_service = function()
        return false
    end
    bios_service:get_cpu_ids()
    bios_factory.get_service = function()
        return {
            get_object_list = function()
                return {
                    {
                        DeviceLocator = {
                            value =function()
                                return "1"
                            end
                        }
                    }
                }
            end
        }
    end
    bios_service.get_cpu_ids()
    local ok = bios_service.check_cpuid_right({1, 2, 3}, 1)
    lu.assertEquals(ok, true)
     ok = bios_service.check_cpuid_right({1, 2, 3}, 4)
    lu.assertEquals(ok, false)
    bios_factory.get_service = c_get_service
end

function TestReportAlarm:test_get_power_type()
    local _, val = pcall(bios_service.get_power_type, self, 0)
    lu.assertEquals(val, 'CORE')
    local ok = pcall(bios_service.get_power_type, self, 9)
    lu.assertEquals(ok, false)
end


function TestReportAlarm:test_generate_event()
    local GetEventsEventsObject = client.GetEventsEventsObject
    client.GetEventsEventsObject = function ()
        local obj = {}
        obj.AddEvent_PACKED = function ()
            local inside_obj = {}
            inside_obj.unpack = function ()
                return 1
            end
            return inside_obj
        end
        return obj
    end
    local msg = {}
    local ok = pcall(event.generate_event, msg)
    lu.assertEquals(ok, true)
    client.GetEventsEventsObject = GetEventsEventsObject
end