local bios_object = require 'pojo.bios_object_mutihost'
local bios_service = require 'service.bios_service'
local bios_app = require 'bios_app'

TestMemSilk = {}

function TestMemSilk:setupClass()
    self.get_obj = bios_service.get_obj
    self.service = bios_app.service
    self.mem_silk_array = bios_object.mem_silk_array
end
 
function TestMemSilk:teardownClass()
    bios_service.get_obj = self.get_obj
    bios_app.service = self.service
    bios_object.mem_silk_array = self.mem_silk_array
end

function TestMemSilk:test_add_mem_silk()
    local object = {
        CpuId = 0,
        ChannelId = 1,
        LogicalChannelId = 7,
        DimmId = 0,
        DimmName = "DIM000"
    }
    bios_app.bios_service = bios_service
    object.get_system_id = function ()
        return 1
    end
    bios_service.get_obj = function ()
        return bios_object
    end
    bios_object.mem_silk_array = {}
    bios_app:on_add_object_extra("MemorySilk", object, "0101")
    bios_object:extract_add_memsilk(object)
end
