-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local file_object = require 'pojo.file_object'
local prop_def = require 'macros.property_def'
local lu = require 'luaunit'
TestFileObject = {}

function TestFileObject:test_new()
    local data_opt = file_object.new()
    lu.assertEquals(data_opt.data_operate.data_flag, 0)
    lu.assertEquals(data_opt.data_operate.data_offset, 0)
    lu.assertEquals(data_opt.data_operate.data_len, 0)
    lu.assertIsNil(data_opt.data_operate.data_buf)
    lu.assertEquals(data_opt.data_operate.file_size_limit, 0)
end

function TestFileObject:test_get_flag()
    local data_opt = file_object.new()
    lu.assertEquals(data_opt:get_flag(), 0)
end

function TestFileObject:test_set_flag()
    local data_opt = file_object.new()
    data_opt:set_flag(prop_def.BIOS_FLAG_DOING)
    lu.assertEquals(data_opt:get_flag(), prop_def.BIOS_FLAG_DOING)
end

function TestFileObject:test_get_offset()
    local data_opt = file_object.new()
    lu.assertEquals(data_opt:get_offset(), 0)
end

function TestFileObject:test_set_offset()
    local data_opt = file_object.new()
    data_opt:set_offset('string')
    lu.assertEquals(data_opt:get_offset(), 0)
    data_opt:set_offset(20)
    lu.assertEquals(data_opt:get_offset(), 20)
end

function TestFileObject:test_get_len()
    local data_opt = file_object.new()
    lu.assertEquals(data_opt:get_len(), 0)
end

function TestFileObject:test_set_len()
    local data_opt = file_object.new()
    data_opt:set_len(-1)
    lu.assertEquals(data_opt:get_len(), 0)
    data_opt:set_len('string')
    lu.assertEquals(data_opt:get_len(), 0)
    data_opt:set_len(2)
    lu.assertEquals(data_opt:get_len(), 2)
end

function TestFileObject:test_get_buf()
    local data_opt = file_object.new()
    lu.assertIsNil(data_opt:get_buf())
end

function TestFileObject:test_set_buf()
    local data_opt = file_object.new()
    data_opt:set_buf("123")
    lu.assertEquals(data_opt:get_buf(), "123")
end