-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local boot_option_service = require 'service.boot_options_service'
local import_export_eng = require 'handler.export_import_engine'
local bios_factory = require 'factory.bios_factory'
local bs_util = require 'util.base_util'
local lu = require 'luaunit'

TestExportImportEngine = {}

function TestExportImportEngine:test_engin_import()
    local config_table = {
        ["CustomSettings"] =  {}
    }
    local ok = pcall(function()
        import_export_eng.test_custom_import(config_table)
    end)
    lu.assertEquals(ok, true)

    config_table = {
        ["CustomSettings"] =  {
            ["BMCSet_BootFlagValidTimeoutAutoClearEnabled"] = {}
        }
    }
    ok = pcall(function()
        import_export_eng.test_custom_import(config_table)
    end)
    lu.assertEquals(ok, true)
    config_table = {
        ["CustomSettings"] =  {
            ["BMCSet_BootFlagValidTimeoutAutoClearEnabled"] = {
                ['Value'] = 'on'
            }
        }
    }

    local service = {}
    service.import = function()
    end
    import_export_eng.register_config_dealer('BootOptionService', service)

    ok = pcall(function()
        import_export_eng.test_custom_import(config_table)
    end)
    lu.assertEquals(ok, true)
end

function TestExportImportEngine:test_engin_export()
    local config_table = {
        ["CustomSettings"] = {}
    }

    local service = {}
    service.export = function()
        return {}
    end
    import_export_eng.register_config_dealer('BootOptionService', service)

    local ok = pcall(function()
        import_export_eng.test_custom_export(config_table)
    end)
    lu.assertEquals(ok, true)
end