-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local alarm = require 'domain.alarm.alarm'
local client = require 'bios.client'
local lu = require 'luaunit'


TestAlarm = {}

function TestAlarm:test_format_component_name()
    local mock_1 = alarm.get_cpu_component_name
    alarm.get_cpu_component_name = function(...)
        return 'test'
    end
    local event = {
        ComponentName = 'CpuBoard',
        SystemId = ''
    }
    lu.assertEquals(alarm:format_component_name(event, ''), nil)
    alarm.get_cpu_component_name = mock_1
    local msg = {
        args = {
            DeviceLocator = nil
        }
    }
    lu.assertEquals(alarm:get_cpu_component_name(msg), 'CpuBoard1')

    msg = {
        args = {
            DeviceLocator = 'CPU2'
        }
    }
    local obj = {
        Id = 2,
        Position = 'CpuBoard2'
    }
    local ForeachProcessorObjects_mcok = client.ForeachProcessorObjects
    client.ForeachProcessorObjects = function(_, func)
        return func(obj)
    end
    lu.assertEquals(alarm:get_cpu_component_name(msg), 'CpuBoard2')
    client.ForeachProcessorObjects = ForeachProcessorObjects_mcok
end
