-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local BIOS_PATH = '/bmc/kepler/Systems/1/Bios'
local BIOS_INTERFACE = 'bmc.kepler.Systems.Bios'
local mdb = require 'mc.mdb'

local test_bios_cfg = {}

function test_bios_cfg.test_import(bus)
    log:info('================ test import bios start ================')
    local obj = mdb.get_object(bus, BIOS_PATH, BIOS_INTERFACE)
    obj:ImportBiosConfig_PACKED(require'mc.context'.new())
    log:info('================ test import bios end ================')
end

function test_bios_cfg.test_cfg(bus)
    test_bios_cfg.test_import(bus)
end

return test_bios_cfg
