-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local IpmiCore = {}

local Mdb = require 'mc.mdb'

local IpmiMsg = require 'stub_service.types.message'

---@class IIpmiServiceInterface: Table
IpmiCore.IIpmiServiceInterface = Mdb.register_interface('bmc.kepler.IpmiCore', {}, {
    Request = {'a{ss}yyyyyay', 'yay', IpmiMsg.IpmiCmdReq, IpmiMsg.IpmiCmdRsp},
    Route = {'a{ss}ayay', 'ay', IpmiMsg.IpmiRouteReq, IpmiMsg.IpmiRouteRsp}
}, {})

return IpmiCore
