-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local singleton = require 'mc.singleton'
local clsmgmt = require 'mc.class_mgnt'

local peripherals_device = class()

function peripherals_device:ctor(bus)
    self.bus = bus
    self.sys_fw_progress = {}
end

local function get_system_id(path)
    return tonumber(string.match(path, '/bmc/kepler/Systems/(%d+)'))
end

function peripherals_device:add_object(object)
    local system_id = get_system_id(object.path)
    self.sys_fw_progress[system_id] = object
end

function peripherals_device:delete_object(object)
    local system_id = get_system_id(object.path)
    if not system_id or not self.sys_fw_progress[system_id] then
        return
    end
    clsmgmt('SystemFirmwareProgress'):remove(object)
    self.sys_fw_progress[system_id] = nil
end

function peripherals_device:set_kbc_err(system_id, value)
    local obj = self.sys_fw_progress[system_id]
    if obj then
        obj.KBCError = value
    end
end

function peripherals_device:set_video_err(system_id, value)
    local obj = self.sys_fw_progress[system_id]
    if obj then
        obj.VideoError = value
    end
end

function peripherals_device:recover_device_status(system_id)
    local object = self.sys_fw_progress[system_id]
    if object then
        object.KBCError = 0
        object.VideoError = 0
    end
end

return singleton(peripherals_device)