-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local prop_def = require "macros.property_def"
local class = require 'mc.class'
local log = require 'mc.logging'
local bs_util = require 'util.base_util'
local clsmgmt = require 'mc.class_mgnt'

local secure_boot_options_object = class()

-- 向前兼容，当sys_id为1时，先获取CertInfo_1的数据，如果没有则使用CertInfo的数据创建新数据
local function get_secure_boot_options_table(db, sys_id)
    local db_id = 'CertInfo'
    if sys_id ~= prop_def.DEFAULT_SYSTEM_ID then
        db_id = 'CertInfo_' .. sys_id
    end
    local db_info = db:select(db.CertInfoTable)
        :where(db.CertInfoTable.Id:eq(db_id)):first()
    if db_info then
        return db_info
    end
    local new_db_info = db.CertInfoTable({Id = db_id,
        CertificateExpired = 0})
    new_db_info:save()
    return new_db_info
end

function secure_boot_options_object:ctor(db, sys_id, obj, position)
    self.position = position
    self.cert_db_obj = get_secure_boot_options_table(db, sys_id)
    -- 当前只有一个证书过期告警属性，无需新建对象，不作额外处理
    self.secure_boot_options_obj = obj

    self.new_secureboot = bs_util.get_conf_path(sys_id, prop_def.NEW_SECUREBOOT_FILE)
    self.current_secureboot = bs_util.get_conf_path(sys_id, prop_def.CURRENT_SECUREBOOT_FILE)

    if not self.cert_db_obj then
        log:error('get cert db obj failed')
        return
    end
    if self.cert_db_obj[prop_def.CERT_STATUS] then
        self.secure_boot_options_obj[prop_def.CERT_STATUS]
            = self.cert_db_obj[prop_def.CERT_STATUS]
    end
end

function secure_boot_options_object:update_object(obj, position)
    clsmgmt('SecureBootOptions'):remove(self.secure_boot_options_obj)
    self.secure_boot_options_obj = obj
    obj:register_mdb_objects()
    self.position = position

    if not self.cert_db_obj then
        log:error('get cert db obj failed')
        return
    end
    if self.cert_db_obj[prop_def.CERT_STATUS] then
        self.secure_boot_options_obj[prop_def.CERT_STATUS]
            = self.cert_db_obj[prop_def.CERT_STATUS]
    end
end

function secure_boot_options_object:set_secure_boot_options_obj(prop, value)
    if not self.secure_boot_options_obj[prop] then
        return
    end
    self.secure_boot_options_obj[prop] = value
    return true
end

function secure_boot_options_object:set_cert_db_obj(prop, value)
    if not self.cert_db_obj[prop] then
        return
    end
    self.cert_db_obj[prop] = value
    self.cert_db_obj:save()
    return true
end

function secure_boot_options_object:set_prop(prop, value)
    if self:set_secure_boot_options_obj(prop, value) then
        self:set_cert_db_obj(prop, value)
        return true
    end

    return false
end

function secure_boot_options_object:get_prop(prop)
    if not self.secure_boot_options_obj[prop] then
        return
    end

    return self.secure_boot_options_obj[prop]
end

return secure_boot_options_object