-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require "mc.class"
local prop_def = require 'macros.property_def'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'
local firmware_object = class()

local function init_path(path)
    local file = file_sec.open_s(path, 'r')
    if file == nil then
        utils.mkdir_with_parents(path, utils.S_IRWXU | utils.S_IRGRP | utils.S_IXGRP)
        return
    end
    file:close()
end

function firmware_object:ctor()
    self.FwVerifyResult = prop_def.VERIFY_RESULT_SUCCESS
    self.BackupFwVerifyResult = prop_def.VERIFY_RESULT_SUCCESS
    self.PfrBiosGoldFile = '/data/backup/bios/gold/bios.hpm'
    self.PfrBiosTmpFile = '/data/backup/bios/tmp/bios.hpm'
    init_path('/data/backup/bios/tmp')
    init_path('/data/backup/bios/gold')
end

function firmware_object:get_prop(prop)
    return self[prop]
end

function firmware_object:set_prop(prop, val)
    if not self[prop] then
        return false
    end

    self[prop] = val
    return true
end

return firmware_object