-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local property_def = {}

-- file_selector宏定义 BEGIN
property_def.BIOS_FILE_DISPLAY_NUM = 0x00
property_def.BIOS_FILE_OPTION_NUM = 0x01
property_def.BIOS_FILE_CHANGE_NUM = 0x02
property_def.BIOS_FILE_DEBUG_INFO = 0x03
property_def.BIOS_FILE_FIRMWARE = 0x04
property_def.BIOS_FILE_NETCONFIG = 0x05
property_def.BIOS_FILE_SOL = 0x06
property_def.BIOS_FILE_BLACKBOX = 0x07
property_def.BIOS_FILE_CLP = 0x08
property_def.BIOS_FILE_CLP_RESP = 0x09
property_def.BIOS_FILE_SETUP_NUM = 0x0c
property_def.BIOS_FILE_SMBIOS_RAS = 0x0d
property_def.BIOS_FILE_REGISTRY_NUM = 0x19
property_def.BIOS_FILE_CURRENT_VALUE_NUM = 0x1a
property_def.BIOS_FILE_SETTING_NUM = 0x1b
property_def.BIOS_FILE_RESULT_NUM = 0x1c
property_def.BIOS_FILE_SILK_CONFIG_NUM = 0x2a
property_def.BIOS_FILE_NEW_SECUREBOOT_NUM = 0x2b
property_def.BIOS_FILE_CURRENT_SECUREBOOT_NUM = 0x2c
property_def.BIOS_FILE_PSUINFO_NUM = 0x2f
property_def.BIOS_FILE_CMES_NUM = 0x1e
-- file_selector宏定义 END

property_def.BIOS_DEMT_ENABLED = "Enabled"
property_def.BIOS_DEMT_DISABLED = "Disabled"

property_def.BIOS_DEMT_CFG_DISABLED = 0
property_def.BIOS_DEMT_CFG_ENABLED = 1
property_def.BIOS_DEMT_CFG_INVALID = 2

property_def.BIOS_SETTING_FILE_INEFFECTIVE = 0
property_def.BIOS_SETTING_FILE_EFFECTIVE = 1

property_def.BIOS_SETTING_FILE_UNCHANGED = 0
property_def.BIOS_SETTING_FILE_CHANGED = 1

property_def.DEFAULT_REGISTRY_VERSION = "V0.00"

property_def.MAX_FILE_SIZE_90M = 90 * 1024 * 1024
property_def.BIOS_FILE_MAX_SIZE = 10 * 1024 * 1024
property_def.BIOS_MAXDATA_LEN = (248 - 12)

property_def.BIOS_FLAG_IDLE = 0x00
property_def.BIOS_FLAG_DOING = 0x01

property_def.BIOS_FILE_NO_MORE_DATA = 0x01
property_def.BIOS_FILE_MORE_DATA = 0X00

property_def.BIOS_IPMI_CMD_MIN_LEN = 4

property_def.BIOS_PCIEDISK_BDF_ABNORMAL = 0x00
property_def.BIOS_IPMI_CMD_PCIECARD = 0xC6
property_def.BIOS_IPMI_CMD_PCIEDISK = 0xC8
property_def.BIOS_IPMI_CMD_OCPCARD = 0xCC

property_def.BIOS_BOOT_STAGE_OFF = 0x00
property_def.BIOS_BOOT_STAGE_PCIE_INFO_REPORTED = 0x01

property_def.BDF_MAX_FRAME_NUM = 1
property_def.BDF_CURRENT_FRAME = 2
property_def.BDF_FRAME_PCIE_NUM = 3
property_def.BDF_FIRST_FRAME = 1

property_def.PROPERTY_BIOS_PCIECARD_BDF = "PcieCardBDF"
property_def.PROPERTY_BIOS_PCIEDISK_BDF = "PcieDiskBDF"
property_def.PROPERTY_BIOS_OCPCARD_BDF = "OCPCardBDF"
property_def.PROPERTY_BIOS_BOOT_STAGE = "BiosBootStage"
property_def.BDF_DATA_SIZE = 2048

property_def.BIOS_ERR_WRONG_OFFSET = 0x81
property_def.BIOS_ERR_IV_LEN = 0x83

property_def.ENUM_TYPE = "enum"
property_def.STRING_TYPE = "string"

property_def.RESPONSE_ERROR = -1
property_def.RESPONSE_OK = 0
property_def.RESPONSE_CONFIG_PATH_NULL = 1
property_def.RESPONSE_BIOS_SERVICE_NULL = 2
property_def.RESPONSE_READ_JSON_FAILURE = 3
property_def.RESPONSE_FILE_PATH_NULL = 4
property_def.RESPONSE_FILE_JSON_NULL = 5
property_def.RESPONSE_REGISTRY_SERVICE_NULL = 6
property_def.RESPONSE_CURRENTVALUE_SERVICE_NULL = 7
property_def.RESPONSE_UPDATE_ATTRIBUTE_FAIL = 8
property_def.RESPONSE_OPEN_EXPORT_FILE_NULL = 9
property_def.RESPONSE_OPEN_EXPORT_FILE_FAIL = 10
property_def.RESPONSE_REGISTRY_NULL = 11
property_def.RESPONSE_XML_CONTENT_NULL = 12
property_def.RESPONSE_XML_OPEN_XML_FAIL = 13
property_def.RESPONSE_XML2JSON_FAIL = 14
property_def.RESPONSE_IMPORT_FILE_NOT_EXIST = 15
property_def.RESPONSE_XML_INFO_INVALID = 16
property_def.RESPONSE_XML_FORMAT_INVALID = 17
property_def.RESPONSE_BIOS_VERSION_INVALID = 18
property_def.RESPONSE_BOOTTYPEORDER_ERROR = 19
property_def.RESPONSE_IMPORT_ERROR = 20
property_def.RESPONSE_WRITE_JSON_FAIL = 21
property_def.RESPONSE_JSON_TO_LIST_FAIL = 22
property_def.RESPONSE_REGISTRY_JSON_INVALID = 23
property_def.RESPONSE_CURRENTVALUE_JSON_NULL = 24
property_def.RESPONSE_MODE_FAILURE = 255

property_def.RESPONSE_IMPORT_OK = "ok"
property_def.RESPONSE_INNER_ERROR = "inner error"

property_def.REGRIST_PROP_TYPE_ENUM = "Enumeration"
property_def.REGRIST_PROP_TYPE_STRING = "String"
property_def.REGRIST_PROP_TYPE_INTEGER = "Integer"
property_def.REGRIST_PROP_TYPE_BOOLEAN = "Boolean"
property_def.REGRIST_PROP_TYPE_PASSWORD = "Password"
property_def.REGRIST_PROP_REGISTRYENTRIES = "RegistryEntries"
property_def.REGRIST_PROP_ATTRIBUTES = "Attributes"
property_def.REGRIST_PROP_DEPENDENCIES = "Dependencies"
property_def.REGRIST_PROP_MENUS = "Menus"
property_def.REGRIST_PROP_MEUNNAME = "MenuName"
property_def.REGRIST_PROP_LANGUAGE = "Language"
property_def.REGRIST_PROP_ATTRIBUTENAME = "AttributeName"
property_def.REGRIST_PROP_IMMUTABLE = "Immutable"
property_def.REGRIST_PROP_HIDDEN = "Hidden"
property_def.REGRIST_PROP_READONLY = "ReadOnly"
property_def.REGRIST_PROP_TYPE = "Type"
property_def.REGRIST_PROP_VALUE = "Value"
property_def.REGRIST_PROP_VALUENAME = "ValueName"
property_def.REGRIST_PROP_MAXLENGTH = "MaxLength"
property_def.REGRIST_PROP_MINLENGTH = "MinLength"
property_def.REGRIST_PROP_VALUEEXPRESSION = "ValueExpression"
property_def.REGRIST_PROP_UPPERBOUND = "UpperBound"
property_def.REGRIST_PROP_LOWERBOUND = "LowerBound"
property_def.REGRIST_PROP_SCALARINCREMET = "ScalarIncrement"
property_def.REGRIST_PROP_CURRENTVALUE = "CurrentValue"
property_def.REGRIST_PROP_DEPENDENCYFOR = "DependencyFor"
property_def.REGRIST_PROP_DEPENDENCY = "Dependency"
property_def.REGRIST_PROP_MAPFORM = "MapFrom"
property_def.REGRIST_PROP_MAPFORMATTRIBUTE = "MapFromAttribute"
property_def.REGRIST_PROP_MAPFROMPROPERTY = "MapFromProperty"
property_def.REGRIST_PROP_MAPTERMS = "MapTerms"
property_def.REGRIST_PROP_MAPFROMCONDITION = "MapFromCondition"
property_def.REGRIST_PROP_MAPFROMVALUE = "MapFromValue"
property_def.REGRIST_PROP_MAPTOATTRIBUTE = "MapToAttribute"
property_def.REGRIST_PROP_MAPTOPROPERTY = "MapToProperty"
property_def.REGRIST_PROP_MAPTOVALUE = "MapToValue"
property_def.REGRIST_PROP_BOOTTYPEORDER = "BootTypeOrder"
property_def.REGRIST_PROP_BOOTTYPEORDER0 = "BootTypeOrder0"
property_def.REGRIST_PROP_BOOTTYPEORDER1 = "BootTypeOrder1"
property_def.REGRIST_PROP_BOOTTYPEORDER2 = "BootTypeOrder2"
property_def.REGRIST_PROP_BOOTTYPEORDER3 = "BootTypeOrder3"
property_def.REGRIST_PROP_REGISTRYVERSIOHN = "RegistryVersion"

property_def.E_OK = 0
property_def.HTTP_OK = 200
property_def.E_FAILURE = -1
property_def.E_CONTINUE = -2
property_def.E_END = -3

-- PCIe卡名称 BEGIN
property_def.COMPONENT_NVME_STR = "NVMe"
property_def.COMPONENT_PCIE_STR = "PCIe"
property_def.COMPONENT_OCP_STR = "OCP"
-- PCIe卡名称 END

-- PCIe卡类型ID BEGIN
property_def.COMPONENT_TYPE_HARDDISK = 2
property_def.COMPONENT_TYPE_PCIE_CARD = 8
property_def.COMPONENT_TYPE_NIC_CARD = 13
property_def.COMPONENT_TYPE_OCP = 83
property_def.COMPONENT_TYPE_SAS = 71
-- PCIe卡类型ID END

-- silkconfig.json宏声明 BEGIN
property_def.BIOS_SILK_JSON_FILE_HEADER = "Properties"
property_def.BIOS_SILK_JSON_HEADER_TYPE = "Type"
property_def.BIOS_SILK_JSON_HEADER_TYPE_STR = "BIOS SILK CFG"
property_def.BIOS_SILK_JSON_HEADER_VERSION = "Version"
property_def.BIOS_SILK_JSON_HEADER_VER_VALUE = 1
property_def.BIOS_SILK_JSON_PCIE_TITLE = "PCIeSilk"
property_def.BIOS_SILK_JSON_MEM_TITLE = "MemSilk"
property_def.BIOS_SILK_JSON_NIC_TITLE = "NICSilk"
property_def.BIOS_SILK_JSON_DISK_TITLE = "DiskSilk"
property_def.BIOS_SILK_JSON_CPU_TITLE = "CpuSilk"
property_def.SILK_JSON_PCIE_TYPE = 1
property_def.SILK_JSON_NIC_TYPE = 1
property_def.BIOS_SILK_JSON_FILE_NAME = "/data/opt/bmc/conf/bios/silkconfig.json"
property_def.BIOS_SILK_JSON_BAK_FILE_NAME = "/data/opt/bmc/conf/bios/silkconfig_bak.json"
property_def.BIOS_SILK_JSON_SEGMENT = "Segment"
property_def.BIOS_SILK_JSON_SOCKET_ID = "SocketId"
property_def.BIOS_SILK_JSON_ROOT_DEVICE_ID = "RootPortDeviceId"
property_def.BIOS_SILK_JSON_PHY_CHANNEL_ID = "PhysicalChannelId"
property_def.BIOS_SILK_JSON_LOGICAL_CHANNEL_ID = "LogicalChannelId"
property_def.BIOS_SILK_JSON_DIMM_ID = "DimmId"
property_def.BIOS_SILK_JSON_SLOT_ID = "SlotId"
property_def.BIOS_SIKL_JSON_PHY_ID = "PhyId"
property_def.BIOS_SIKL_JSON_PHYSICAL_ID = "PhysicalSocketId"
property_def.BIOS_SIKL_JSON_LOGICAL_ID = "LogicalSocketId"
property_def.BIOS_SIKL_JSON_CONTROL_ID = "ControlId"
property_def.BIOS_SIKL_JSON_CONTROL_ID_SAS = 1
property_def.BIOS_SIKL_JSON_CONTROL_ID_SATA = 2
property_def.BIOS_SILK_JSON_ROOT_BDF = "RootBDF"
property_def.BIOS_SILK_JSON_DEVICE_TYPE = "DeviceType"
property_def.BIOS_SILK_JSON_SILK = "Silk"
property_def.CPU_DEVICE_LOCATOR = "DeviceLocator"
-- silkconfig.json宏定义 END

property_def.REGRIST_STRING_AND = "AND"
property_def.REGRIST_STRING_OR = "OR"

property_def.EXPORT_FILE_TRUE = true  -- 标识导出文件操作
property_def.EXPORT_FILE_FALSE = false -- 标识非导出文件操作

property_def.REGRIST_TYPE_PROP_UNKNOWN = 2
property_def.REGRIST_TYPE_PROP_IMMUTABLE = 3
property_def.REGRIST_TYPE_PROP_READONLY = 4
property_def.REGRIST_TYPE_PROP_NOT_LIST = 5
property_def.REGRIST_TYPE_PROP_LENGTH_ERR = 6
property_def.REGRIST_TYPE_PROP_NOT_RANGE = 8
property_def.REGRIST_TYPE_PROP_TYPE_ERROR = 9
property_def.REGRIST_TYPE_PROP_SCALAR_INCREMENT = 10
property_def.REGRIST_TYPE_PROP_HIDE = 11
property_def.REGRIST_INTERNEL_ERROR = 255

property_def.INT_TYPE = "int"
property_def.BOOLEAN_TYPE = "boolean"
property_def.STRING_TYPE = "string"
property_def.NUMBER_TYPE = "number"

property_def.REGRIST_PROP_COMPARE_EQU = "EQU"
property_def.REGRIST_PROP_COMPARE_NEQ = "NEQ"
property_def.REGRIST_PROP_COMPARE_GTR = "GTR"
property_def.REGRIST_PROP_COMPARE_GEQ = "GEQ"
property_def.REGRIST_PROP_COMPARE_LSS = "LSS"
property_def.REGRIST_PROP_COMPARE_LEQ = "LEQ"

property_def.BIOS_VERSION = "bios_version"
property_def.TMP_BIOS_CONFIG_XML = "/tmp/config.xml"

property_def.DOWNLOAD_BIOS_POSITION = "/dev/shm/"
property_def.EXPORT_BIOS_PATH = "/dev/shm/bios/"
property_def.EXPORT_DIR_NAME = "bios"
property_def.DOWNLOAD_BIOS_FILE_NAME = 'bios.bin'
property_def.DOWNLOAD_BIOS_TAR_INSIDE_NAME = "/dev/shm/tmp/bios.tar.gz"
property_def.DOWNLOAD_BIOS_TAR_NAME = "/tmp/bios.tar.gz"
property_def.SPIKODRV = '/lib/modules/ko/sfc0_drv.ko'
property_def.DEVNAME_BIOS_V6 = '/dev/mtd0'
property_def.O_SYNC_RDWR = 4098  -- 读写权限flag为4098

property_def.BIOS_FILE_LEN = 16 * 1024 * 1024
property_def.BIOS_FILE_LEN_KUNPENGB = 1024 * 1024

property_def.BIOS_PERIOD2 = 2
property_def.BIOS_PERIOD3 = 3
property_def.KUNPENGBEXID = 0x82

property_def.BIOS_BOOT_MODE_SW_OFF = 0
property_def.BIOS_BOOT_MODE_SW_ON = 1
property_def.BIOS_PWD_COMPLEXITYLEN_MIN = 8
property_def.BIOS_PWD_COMPLEXITYLEN_MAX = 16
property_def.BIOS_PWD_LEN_MAX = 32
property_def.METHOD_BIOS_CHANGE_PWD_UNSUPPORTED = 0xe001
property_def.METHOD_BIOS_CHANGE_PWD_LEN_INVALID = 0xe002
property_def.DOMAIN_ID_BIOS = 14
property_def.BIOS_PWD_NAME_SUPERVISOR = "Supervisor"
property_def.BIOS_PWD_NAME_ADMIN = "AdminPassword"
property_def.BIOS_PWD_NAME_USER = "UserPassword"
property_def.SYSTEM_STARTUP_STATE = "SystemStartupState"
property_def.RESET_BIOS_TO_DEFAULTS_PENDING = "ResetBiosToDefaultsPending"
property_def.PWD_TYPE = 2
property_def.COMP_CODE_PARAM_NOT_SUPPORTED = 0x80
property_def.BIOS_CHANGE_PWD_SELECTOR_GET = 0
property_def.BIOS_CHANGE_PWD_SELECTOR_ACK = 1
property_def.BIOS_CHANGE_PWD_TASK_IDLE = 0
property_def.BIOS_CHANGE_PWD_TASK_WAIT_ACK = 1
property_def.BIOS_CHANGE_SUP_PWD_TYPE_SETUP = 0
property_def.BIOS_CHANGE_USER_PWD_TYPE_SETUP = 1
property_def.BIOS_CHANGE_PWD_OK = 0
property_def.BIOS_CHANGE_PWD_FAILED = 1
property_def.BIOS_LOAD_DEFAULT_CONF = 0
property_def.INVALID_ID = 0xFF
property_def.VERIFY_RESULT_SUCCESS = 0
property_def.VERIFY_RESULT_FAILED = 1

property_def.ParameterRevision = 0x11
property_def.BIOS_STARTUP_POST_STAGE_FINISH = 0xFE
property_def.BIOS_FILE_MAX_SELECTOR = 0x32
property_def.BIOS_REPORT_POST_FINISH_FLAG = 0x01

property_def.IMANA_LOG_SECURITY = 0
property_def.IMANA_LOG_OPERATION = 1

-- 安全启动相关类方法返回码
property_def.SECUREBOOT_METHOD_OK = 0
property_def.SECUREBOOT_METHOD_ERR = -1
property_def.SECUREBOOT_METHOD_INVALID_PARAM = -2 -- 参数无效
property_def.SECUREBOOT_METHOD_EXPIRED_CERT = -3 -- 过期证书
property_def.SECUREBOOT_METHOD_BIOS_STATE_UNSUPPORT = -4 -- BIOS正在启动阶段，不支持相关操作
property_def.SECUREBOOT_METHOD_PEM_FORMAT_ERR = -5 -- PEM格式错误
property_def.SECUREBOOT_METHOD_STRING_TOO_LONG = -6 -- 字符串参数过长
property_def.SECUREBOOT_METHOD_IMPORT_LIMIT = -7 -- 超过导入限制

-- 写SMBIOS操作步骤
property_def.SMBIOS_WRITE_PREPARE = 0x00
property_def.SMBIOS_WRITE_DATA = 0x01
property_def.SMBIOS_WRITE_FINISH = 0x03
property_def.SMBIOS_WRITE_NOT_START = 0x04

-- BIOS启动阶段标记
property_def.BIOS_STARTUP_STATE_OFF = 0x00
property_def.BIOS_STARTUP_ME_EOP = 0x20
property_def.BIOS_STARTUP_PCIE_INFO_REPORTED = 0x40
property_def.BIOS_STARTUP_SMBIOS_WRITE_PREPARE = 0x60
property_def.BIOS_STARTUP_SMBIOS_WRITE_DATA = 0x63
property_def.BIOS_STARTUP_SMBIOS_WRITE_FINISH = 0x66
property_def.BIOS_STARTUP_PXE_START = 0x6F
property_def.BIOS_STARTUP_POST_STAGE_FINISH = 0xFE

-- 证书交互文件定义的键值(与BIOS存在协议约定，不可随意更改)
property_def.INTERACT_KEY_SECUREBOOT = 'SecureBoot'
property_def.INTERACT_KEY_SECUREBOOT_DATABASES = 'SecureBootDataBases'
property_def.INTERACT_KEY_SECUREBOOT_DB ='db'
property_def.INTERACT_KEY_SECUREBOOT_DBX = 'dbx'
property_def.INTERACT_KEY_UEFI_SIGNATUREOWNER = 'UefiSignatureOwner'
property_def.INTERACT_KEY_BOOT = 'Boot'
property_def.INTERACT_KEY_CERTIFICATE_STRING = 'CertificateString'
property_def.INTERACT_KEY_CERTIFICATE_TYPE = 'CertificateType'
property_def.INTERACT_KEY_CERTIFICATES = 'Certificates'
property_def.INTERACT_KEY_OPERATION = 'Operation'
property_def.INTERACT_KEY_SIZE = 'Size'
property_def.INTERACT_KEY_CRL = 'Crl'
property_def.CERT_OPERATION_ADD = 'Add'
property_def.CERT_OPERATION_DELETE = 'DeleteAllKeys'
property_def.CERT_OPERATION_RESET = 'ResetAllKeysToDefault'
-- 对外返回的证书信息键值(与网管存在协议约定，不可随意更改)
property_def.HTTPSBOOT_CERT = 'HttpsCert'
property_def.HTTPSBOOT_CRL = 'HttpsCrl'
property_def.CERT_DETAILS_ISSUER = 'Issuer'
property_def.CERT_DETAILS_SUBJECT = 'Subject'
property_def.CERT_DETAILS_COUNTRY = 'Country'
property_def.CERT_DETAILS_STATE = 'State'
property_def.CERT_DETAILS_CITY = 'City'
property_def.CERT_DETAILS_ORGANIZATION = 'Organization'
property_def.CERT_DETAILS_ORGANIZATION_UNIT = 'OrganizationUnit'
property_def.CERT_DETAILS_COMMON_NAME = 'CommonName'
property_def.CERT_DETAILS_EMAIL = 'Email'
property_def.CERT_DETAILS_VALID_NOT_BEFORE = 'ValidNotBefore'
property_def.CERT_DETAILS_VALID_NOT_AFTER = 'ValidNotAfter'
property_def.CERT_DETAILS_SERIAL_NUMBER = 'SerialNumber'
property_def.CERT_DETAILS_FINGER_PRINT = 'Fingerprint'
property_def.CERT_DETAILS_FINGER_PRINT_HASH_ALGO = 'FingerprintHashAlgorithm'
property_def.CERT_DETAILS_SIGNATURE_ALGO = 'SignatureAlgorithm'

-- 单个证书文件最大值
property_def.CERT_MAX_SIZE = 102400
property_def.BIOS_MAX_CERT_NUM = 18

-- openssl中keyusage字段对应关系，数字部分
property_def.KU_DIGITAL_SIGNATURE = 0x0080
property_def.KU_NON_REPUDIATION = 0x0040
property_def.KU_KEY_ENCIPHERMENT = 0x0020
property_def.KU_DATA_ENCIPHERMENT = 0x0010
property_def.KU_KEY_AGREEMENT = 0x0008
property_def.KU_KEY_CERT_SIGN = 0x0004
property_def.KU_CRL_SIGN = 0x0002
property_def.KU_ENCIPHER_ONLY = 0x0001
property_def.KU_DECIPHER_ONLY = 0x8000
-- openssl中keyusage字段对应关系，类型部分
property_def.CERT_DETAILS_KEY_USAGE = 'KeyUsage'
property_def.CERT_DETAILS_KEY_USAGE_CRL_SGINING = 'CRLSigning'
property_def.CERT_DETAILS_KEY_USAGE_DATA_ENCIPHERMENT = 'DataEncipherment'
property_def.CERT_DETAILS_KEY_USAGE_DECIPHER_ONLY = 'DecipherOnly'
property_def.CERT_DETAILS_KEY_USAGE_DIGITAL_SIGNATURE  = 'DigitalSignature'
property_def.CERT_DETAILS_KEY_USAGE_ENCIPHER_ONLY = 'EncipherOnly'
property_def.CERT_DETAILS_KEY_USAGE_KEY_AGREEMENT = 'KeyAgreement'
property_def.CERT_DETAILS_KEY_USAGE_KEY_CERT_SIGN = 'KeyCertSign'
property_def.CERT_DETAILS_KEY_USAGE_KEY_ENCIPHERMENT = 'KeyEncipherment'
property_def.CERT_DETAILS_KEY_USAGE_NON_REPUDIATION = 'NonRepudiation'

property_def.BIOS_CONFIG_PATH = '/data/opt/bmc/conf/bios'
property_def.SMBIOS_CONF_FILE = 'SMBIOS_CONF'
property_def.SMBIOS_DIFF_FILE = 'SMBIOS_DIFF'

property_def.BIOS_DATA_PATH = '/data/opt'
property_def.NEW_SECUREBOOT_FILE = 'new_secureboot.json'
property_def.CURRENT_SECUREBOOT_FILE = 'current_secureboot.json'
property_def.CMES_DAT = 'CMES.dat'
property_def.PSU_INFO = 'psu_info.json'
property_def.SILK_NAME = 'silkconfig.json'
property_def.SILK_BAK_NAME = 'silkconfig_bak.json'

property_def.DEASSERT_STATUS = 0
property_def.ASSERT_STATUS = 1
property_def.OVERDUE_DEBOUNCE_TIME = 5
property_def.CERT_STATUS = 'CertificateExpired'

property_def.ENABLED = 1
property_def.DISABLED = 0

property_def.DEFAULT_SYSTEM_ID = 1

property_def.UPLOAD_INSIDE_FW_HPM_NAME = '/dev/shm/tmp/image.hpm'
property_def.UPLOAD_FW_HPM_NAME = '/tmp/image.hpm'
property_def.BIOS_DATA_OFFSET_POS = 5 -- SrcData里数据内容开始的偏移量

property_def.UPGRADE_PATH= '/data/upgrade'
property_def.CACHED_BIOS_PKG = 'bios.tar.gz'
property_def.CACHED_KRUN_PKG = 'krun.tar.gz'

property_def.SYNCHRONIZE_ERROR_CODE = {
    [0x01] = 'Verify failed',
    [0x02] = 'Write flash failed',
    [0x03] = 'Not need upgarde',
    [0x04] = 'Package not match',
}

property_def.OPTION_CODE = {
    [0x00] = "Disabled",
    [0x01] = "TimeoutRetryCount1",
    [0x02] = "TimeoutRetryCount2",
    [0x03] = "TimeoutRetryCount3",
    [0x04] = "TimeoutRetryCount4",
}

property_def.BIOS_CONFIG_ITEM_OPTION_OVER_CODE = 0x04
property_def.BIOS_CONFIG_ITEM_INVALID_FIELD = 0xCC
property_def.BIOS_CONFIG_ITEM_SUCCESS = 0x00
property_def.BIOS_CONFIG_ITEM_FIELD = 0xFF
property_def.COMP_CODE_OUTOF_RANGE = 0xC9
property_def.SET_BIOS_CONFIG_ITEM_DATA_LEN = 3
property_def.CONFIG_ITEM_FOR_PXE_TIMEOUT_RETRY = 0x00

return property_def