-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_factory = {}
local bean_factory = {}

function bios_factory.register_bean(service_name, service)
    if bean_factory[service_name] ~= nil then
        return
    end

    bean_factory[service_name] = service
end

function bios_factory.get_service(service_name)
    -- 判断
    return bean_factory[service_name]
end

function bios_factory.uninstall_bean(service_name)
    if bean_factory[service_name] ~= nil then
        bean_factory[service_name] = nil
    end
end

function bios_factory.register_db_connection(db_connection_name, db_connection)
    if bean_factory[db_connection_name] ~= nil then
        return
    end

    bean_factory[db_connection_name] = db_connection
end

function bios_factory.get_db_connection(db_connection_name)
    -- 判断
    return bean_factory[db_connection_name]
end

return bios_factory
