-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 管理策略重配的标准文件
local class = require 'mc.class'
local component_version = require 'domain.mapping.component_version'
local policy_config_value = require 'domain.mapping.policy_config_value'
local policy_config_registery = require 'domain.mapping.policy_config_registery'
local skynet = require 'skynet'
local base_messages = require 'messages.base'

local ComponentManager = class()

function ComponentManager:ctor(system_id)
    self.component_version = component_version.new(system_id)
    self.policy_config_value = policy_config_value.new(system_id)
    self.policy_config_registery = policy_config_registery.new(system_id)
end

function ComponentManager:fetch_info()
    self.component_version:fetch_info()
    self.policy_config_registery:fetch_info()
end

function ComponentManager:async_fetch_info()
    skynet.fork_once(function ()
        skynet.sleep(3000)
        self:fetch_info()
    end)
end

function ComponentManager:get_data(type)
    local type_tbl = {
        PolicyConfigJson = self.policy_config_value,
        PolicyRegisteryJson = self.policy_config_registery,
        ComponentVersion = self.component_version
    }
    local obj = type_tbl[type]
    if not obj then
        error(base_messages.InternalError())
    end
    return obj:get_data()
end

function ComponentManager:get_componet_bitmap_list(component_names)
    return self.component_version:get_componet_bitmap_list(component_names)
end

function ComponentManager:update_user_data(config_data)
    return self.policy_config_value:update_user_data(config_data)
end

return ComponentManager