-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local memory_types = {}
memory_types.__index = memory_types

function memory_types.new(data)
  return setmetatable({data}, memory_types)
end

function memory_types:other()
  return self[1] & 0x0001 == 0x0001
end

function memory_types:unknown()
  return self[1] & 0x0002 == 0x0002
end

function memory_types:standard()
  return self[1] & 0x0004 == 0x0004
end

function memory_types:fast_page_mode()
  return self[1] & 0x0008 == 0x0008
end

function memory_types:edo()
  return self[1] & 0x0010 == 0x0010
end

function memory_types:parity()
  return self[1] & 0x0020 == 0x0020
end

function memory_types:ecc()
  return self[1] & 0x0040 == 0x0040
end

function memory_types:simm()
  return self[1] & 0x0080 == 0x0080
end

function memory_types:dimm()
  return self[1] & 0x0100 == 0x0100
end

function memory_types:burst_edo()
  return self[1] & 0x0200 == 0x0200
end

function memory_types:sdram()
  return self[1] & 0x0400 == 0x0400
end

local M = {}

function M.decode(type, length, handle, read_fields, strings)
  local t = {}

  local fields = read_fields('BBBHBBB')
  t.socket_designation = strings[fields[1]]
  t.bank_connections = fields[2]
  t.current_speed = fields[3]
  t.current_memory_type = memory_types.new(fields[4])
  t.installed_size = fields[5]
  t.enabled_size = fields[6]
  t.error_status = fields[7]

  return {Handle = handle, Length = length, Type = type, Strings = strings, Fields = t}
end

return M
