-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local M = {}

function M.decode(type, length, handle, read_fields, strings)

    local t = {}

    -- 2.0+
    if length > 0x12 then
        local fields = read_fields('BBHBBJ')
        t.vendor = strings[fields[1]]
        t.firmware_version = strings[fields[2]]
        t.bios_starting_address_segment = fields[3]
        t.firmware_release_date = strings[fields[4]]
    end

    return {Handle = handle, Length = length, Type = type, Strings = strings, Fields = t}
end

return M