-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MVRDTypeMap = {}

---@class MVRDTypeMap.NameRange
---@field NameRange string[]
local TNameRange = {}
TNameRange.__index = TNameRange
TNameRange.group = {}

local function TNameRange_from_obj(obj)
    return setmetatable(obj, TNameRange)
end

function TNameRange.new(NameRange)
    return TNameRange_from_obj({NameRange = NameRange})
end
---@param obj MVRDTypeMap.NameRange
function TNameRange:init_from_obj(obj)
    self.NameRange = obj.NameRange
end

function TNameRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNameRange.group)
end

TNameRange.from_obj = TNameRange_from_obj

TNameRange.proto_property = {'NameRange'}

TNameRange.default = {{}}

TNameRange.struct = {{name = 'NameRange', is_array = true, struct = nil}}

function TNameRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'NameRange', self.NameRange, 'string', false, errs, need_convert)

    TNameRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNameRange.proto_property, errs, need_convert)
    return self
end

function TNameRange:unpack(_)
    return self.NameRange
end

MVRDTypeMap.NameRange = TNameRange

---@class MVRDTypeMap.IdRange
---@field IdRange integer[]
local TIdRange = {}
TIdRange.__index = TIdRange
TIdRange.group = {}

local function TIdRange_from_obj(obj)
    return setmetatable(obj, TIdRange)
end

function TIdRange.new(IdRange)
    return TIdRange_from_obj({IdRange = IdRange})
end
---@param obj MVRDTypeMap.IdRange
function TIdRange:init_from_obj(obj)
    self.IdRange = obj.IdRange
end

function TIdRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIdRange.group)
end

TIdRange.from_obj = TIdRange_from_obj

TIdRange.proto_property = {'IdRange'}

TIdRange.default = {{}}

TIdRange.struct = {{name = 'IdRange', is_array = true, struct = nil}}

function TIdRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'IdRange', self.IdRange, 'uint8', false, errs, need_convert)

    TIdRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIdRange.proto_property, errs, need_convert)
    return self
end

function TIdRange:unpack(_)
    return self.IdRange
end

MVRDTypeMap.IdRange = TIdRange

return MVRDTypeMap
