-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSystemInfoTable = {}

---@class MSystemInfoTable.BaseOsUrlForManageability
---@field BaseOsUrlForManageability string
local TBaseOsUrlForManageability = {}
TBaseOsUrlForManageability.__index = TBaseOsUrlForManageability
TBaseOsUrlForManageability.group = {}

local function TBaseOsUrlForManageability_from_obj(obj)
    return setmetatable(obj, TBaseOsUrlForManageability)
end

function TBaseOsUrlForManageability.new(BaseOsUrlForManageability)
    return TBaseOsUrlForManageability_from_obj({BaseOsUrlForManageability = BaseOsUrlForManageability})
end
---@param obj MSystemInfoTable.BaseOsUrlForManageability
function TBaseOsUrlForManageability:init_from_obj(obj)
    self.BaseOsUrlForManageability = obj.BaseOsUrlForManageability
end

function TBaseOsUrlForManageability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseOsUrlForManageability.group)
end

TBaseOsUrlForManageability.from_obj = TBaseOsUrlForManageability_from_obj

TBaseOsUrlForManageability.proto_property = {'BaseOsUrlForManageability'}

TBaseOsUrlForManageability.default = {''}

TBaseOsUrlForManageability.struct = {{name = 'BaseOsUrlForManageability', is_array = false, struct = nil}}

function TBaseOsUrlForManageability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseOsUrlForManageability', self.BaseOsUrlForManageability, 'string', false, errs,
        need_convert)

    TBaseOsUrlForManageability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseOsUrlForManageability.proto_property, errs, need_convert)
    return self
end

function TBaseOsUrlForManageability:unpack(_)
    return self.BaseOsUrlForManageability
end

MSystemInfoTable.BaseOsUrlForManageability = TBaseOsUrlForManageability

---@class MSystemInfoTable.BMCUrl
---@field BMCUrl string
local TBMCUrl = {}
TBMCUrl.__index = TBMCUrl
TBMCUrl.group = {}

local function TBMCUrl_from_obj(obj)
    return setmetatable(obj, TBMCUrl)
end

function TBMCUrl.new(BMCUrl)
    return TBMCUrl_from_obj({BMCUrl = BMCUrl})
end
---@param obj MSystemInfoTable.BMCUrl
function TBMCUrl:init_from_obj(obj)
    self.BMCUrl = obj.BMCUrl
end

function TBMCUrl:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBMCUrl.group)
end

TBMCUrl.from_obj = TBMCUrl_from_obj

TBMCUrl.proto_property = {'BMCUrl'}

TBMCUrl.default = {''}

TBMCUrl.struct = {{name = 'BMCUrl', is_array = false, struct = nil}}

function TBMCUrl:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BMCUrl', self.BMCUrl, 'string', false, errs, need_convert)

    TBMCUrl:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBMCUrl.proto_property, errs, need_convert)
    return self
end

function TBMCUrl:unpack(_)
    return self.BMCUrl
end

MSystemInfoTable.BMCUrl = TBMCUrl

---@class MSystemInfoTable.PresentOSVersionNumber
---@field PresentOSVersionNumber string
local TPresentOSVersionNumber = {}
TPresentOSVersionNumber.__index = TPresentOSVersionNumber
TPresentOSVersionNumber.group = {}

local function TPresentOSVersionNumber_from_obj(obj)
    return setmetatable(obj, TPresentOSVersionNumber)
end

function TPresentOSVersionNumber.new(PresentOSVersionNumber)
    return TPresentOSVersionNumber_from_obj({PresentOSVersionNumber = PresentOSVersionNumber})
end
---@param obj MSystemInfoTable.PresentOSVersionNumber
function TPresentOSVersionNumber:init_from_obj(obj)
    self.PresentOSVersionNumber = obj.PresentOSVersionNumber
end

function TPresentOSVersionNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresentOSVersionNumber.group)
end

TPresentOSVersionNumber.from_obj = TPresentOSVersionNumber_from_obj

TPresentOSVersionNumber.proto_property = {'PresentOSVersionNumber'}

TPresentOSVersionNumber.default = {''}

TPresentOSVersionNumber.struct = {{name = 'PresentOSVersionNumber', is_array = false, struct = nil}}

function TPresentOSVersionNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PresentOSVersionNumber', self.PresentOSVersionNumber, 'string', false, errs,
        need_convert)

    TPresentOSVersionNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresentOSVersionNumber.proto_property, errs, need_convert)
    return self
end

function TPresentOSVersionNumber:unpack(_)
    return self.PresentOSVersionNumber
end

MSystemInfoTable.PresentOSVersionNumber = TPresentOSVersionNumber

---@class MSystemInfoTable.OperatingSystemName
---@field OperatingSystemName string
local TOperatingSystemName = {}
TOperatingSystemName.__index = TOperatingSystemName
TOperatingSystemName.group = {}

local function TOperatingSystemName_from_obj(obj)
    return setmetatable(obj, TOperatingSystemName)
end

function TOperatingSystemName.new(OperatingSystemName)
    return TOperatingSystemName_from_obj({OperatingSystemName = OperatingSystemName})
end
---@param obj MSystemInfoTable.OperatingSystemName
function TOperatingSystemName:init_from_obj(obj)
    self.OperatingSystemName = obj.OperatingSystemName
end

function TOperatingSystemName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOperatingSystemName.group)
end

TOperatingSystemName.from_obj = TOperatingSystemName_from_obj

TOperatingSystemName.proto_property = {'OperatingSystemName'}

TOperatingSystemName.default = {''}

TOperatingSystemName.struct = {{name = 'OperatingSystemName', is_array = false, struct = nil}}

function TOperatingSystemName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OperatingSystemName', self.OperatingSystemName, 'string', false, errs, need_convert)

    TOperatingSystemName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOperatingSystemName.proto_property, errs, need_convert)
    return self
end

function TOperatingSystemName:unpack(_)
    return self.OperatingSystemName
end

MSystemInfoTable.OperatingSystemName = TOperatingSystemName

---@class MSystemInfoTable.PrimaryOperatingSystemName
---@field PrimaryOperatingSystemName string
local TPrimaryOperatingSystemName = {}
TPrimaryOperatingSystemName.__index = TPrimaryOperatingSystemName
TPrimaryOperatingSystemName.group = {}

local function TPrimaryOperatingSystemName_from_obj(obj)
    return setmetatable(obj, TPrimaryOperatingSystemName)
end

function TPrimaryOperatingSystemName.new(PrimaryOperatingSystemName)
    return TPrimaryOperatingSystemName_from_obj({PrimaryOperatingSystemName = PrimaryOperatingSystemName})
end
---@param obj MSystemInfoTable.PrimaryOperatingSystemName
function TPrimaryOperatingSystemName:init_from_obj(obj)
    self.PrimaryOperatingSystemName = obj.PrimaryOperatingSystemName
end

function TPrimaryOperatingSystemName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrimaryOperatingSystemName.group)
end

TPrimaryOperatingSystemName.from_obj = TPrimaryOperatingSystemName_from_obj

TPrimaryOperatingSystemName.proto_property = {'PrimaryOperatingSystemName'}

TPrimaryOperatingSystemName.default = {''}

TPrimaryOperatingSystemName.struct = {{name = 'PrimaryOperatingSystemName', is_array = false, struct = nil}}

function TPrimaryOperatingSystemName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PrimaryOperatingSystemName', self.PrimaryOperatingSystemName, 'string', false, errs,
        need_convert)

    TPrimaryOperatingSystemName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrimaryOperatingSystemName.proto_property, errs, need_convert)
    return self
end

function TPrimaryOperatingSystemName:unpack(_)
    return self.PrimaryOperatingSystemName
end

MSystemInfoTable.PrimaryOperatingSystemName = TPrimaryOperatingSystemName

---@class MSystemInfoTable.SystemName
---@field SystemName string
local TSystemName = {}
TSystemName.__index = TSystemName
TSystemName.group = {}

local function TSystemName_from_obj(obj)
    return setmetatable(obj, TSystemName)
end

function TSystemName.new(SystemName)
    return TSystemName_from_obj({SystemName = SystemName})
end
---@param obj MSystemInfoTable.SystemName
function TSystemName:init_from_obj(obj)
    self.SystemName = obj.SystemName
end

function TSystemName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemName.group)
end

TSystemName.from_obj = TSystemName_from_obj

TSystemName.proto_property = {'SystemName'}

TSystemName.default = {''}

TSystemName.struct = {{name = 'SystemName', is_array = false, struct = nil}}

function TSystemName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemName', self.SystemName, 'string', false, errs, need_convert)

    TSystemName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemName.proto_property, errs, need_convert)
    return self
end

function TSystemName:unpack(_)
    return self.SystemName
end

MSystemInfoTable.SystemName = TSystemName

---@class MSystemInfoTable.SystemFirmwareVersion
---@field SystemFirmwareVersion string
local TSystemFirmwareVersion = {}
TSystemFirmwareVersion.__index = TSystemFirmwareVersion
TSystemFirmwareVersion.group = {}

local function TSystemFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TSystemFirmwareVersion)
end

function TSystemFirmwareVersion.new(SystemFirmwareVersion)
    return TSystemFirmwareVersion_from_obj({SystemFirmwareVersion = SystemFirmwareVersion})
end
---@param obj MSystemInfoTable.SystemFirmwareVersion
function TSystemFirmwareVersion:init_from_obj(obj)
    self.SystemFirmwareVersion = obj.SystemFirmwareVersion
end

function TSystemFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemFirmwareVersion.group)
end

TSystemFirmwareVersion.from_obj = TSystemFirmwareVersion_from_obj

TSystemFirmwareVersion.proto_property = {'SystemFirmwareVersion'}

TSystemFirmwareVersion.default = {''}

TSystemFirmwareVersion.struct = {{name = 'SystemFirmwareVersion', is_array = false, struct = nil}}

function TSystemFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemFirmwareVersion', self.SystemFirmwareVersion, 'string', false, errs, need_convert)

    TSystemFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TSystemFirmwareVersion:unpack(_)
    return self.SystemFirmwareVersion
end

MSystemInfoTable.SystemFirmwareVersion = TSystemFirmwareVersion

---@class MSystemInfoTable.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj MSystemInfoTable.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

MSystemInfoTable.SystemId = TSystemId

return MSystemInfoTable
